/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import net.nemerosa.ontrack.client.JsonClient;
import net.nemerosa.ontrack.client.JsonClientMappingException;
import net.nemerosa.ontrack.client.JsonClientParsingException;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class JsonClientImpl
implements JsonClient {
    private final OTHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public JsonClientImpl(OTHttpClient httpClient) {
        this.httpClient = httpClient;
        this.objectMapper = ObjectMapperFactory.create();
    }

    @Override
    public JsonNode get(String path, Object ... parameters) {
        return this.httpClient.get(this::toJson, path, parameters);
    }

    @Override
    public JsonNode delete(String path, Object ... parameters) {
        return this.httpClient.delete(this::toJson, path, parameters);
    }

    @Override
    public JsonNode post(Object data, String path, Object ... parameters) {
        try {
            return this.post((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(data), ContentType.create((String)"application/json", (String)"UTF-8")), path, parameters);
        }
        catch (JsonProcessingException e) {
            throw new JsonClientMappingException((IOException)((Object)e));
        }
    }

    @Override
    public JsonNode post(HttpEntity data, String path, Object ... parameters) {
        return this.httpClient.post(this::toJson, data, path, parameters);
    }

    @Override
    public JsonNode put(Object data, String path, Object ... parameters) {
        try {
            return this.httpClient.put(this::toJson, (HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(data), ContentType.create((String)"application/json", (String)"UTF-8")), path, parameters);
        }
        catch (JsonProcessingException e) {
            throw new JsonClientMappingException((IOException)((Object)e));
        }
    }

    @Override
    public JsonNode upload(String name, Document o, String fileName, String path, Object ... parameters) {
        return this.httpClient.upload(this::toJson, name, o, fileName, path, parameters);
    }

    @Override
    public Document download(String path, Object ... parameters) {
        return this.httpClient.download(path, parameters);
    }

    @Override
    public String getUrl(String path, Object ... parameters) {
        return this.httpClient.getUrl(path, parameters);
    }

    @Override
    public JsonNode toNode(Object data) {
        return this.objectMapper.valueToTree(data);
    }

    private JsonNode toJson(String content) {
        JsonNode tree;
        if (StringUtils.isBlank((CharSequence)content)) {
            return JsonUtils.object().end();
        }
        try {
            tree = this.objectMapper.readTree(content);
        }
        catch (IOException e) {
            throw new JsonClientParsingException(e);
        }
        return tree;
    }
}

