/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.gitee.easyopen.ApiDataDecoder;
import com.gitee.easyopen.ApiEncrypter;
import com.gitee.easyopen.ApiInvoker;
import com.gitee.easyopen.ApiParamParser;
import com.gitee.easyopen.ApiRegistEvent;
import com.gitee.easyopen.ApiRespWriter;
import com.gitee.easyopen.ApiResultCreator;
import com.gitee.easyopen.ApiSigner;
import com.gitee.easyopen.ApiValidator;
import com.gitee.easyopen.AppSecretManager;
import com.gitee.easyopen.CacheAppSecretManager;
import com.gitee.easyopen.DataDecoder;
import com.gitee.easyopen.Encrypter;
import com.gitee.easyopen.Invoker;
import com.gitee.easyopen.ParamNames;
import com.gitee.easyopen.ParamParser;
import com.gitee.easyopen.RespWriter;
import com.gitee.easyopen.Result;
import com.gitee.easyopen.ResultCreator;
import com.gitee.easyopen.ResultSerializer;
import com.gitee.easyopen.Signer;
import com.gitee.easyopen.Validator;
import com.gitee.easyopen.auth.Oauth2Manager;
import com.gitee.easyopen.auth.Oauth2Service;
import com.gitee.easyopen.auth.impl.Oauth2ServiceImpl;
import com.gitee.easyopen.bean.ApiDefinition;
import com.gitee.easyopen.config.ConfigClient;
import com.gitee.easyopen.doc.DocFileCreator;
import com.gitee.easyopen.interceptor.ApiInterceptor;
import com.gitee.easyopen.jwt.JwtService;
import com.gitee.easyopen.jwt.impl.JwtServiceImpl;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitManager;
import com.gitee.easyopen.limit.LimitType;
import com.gitee.easyopen.monitor.ApiMonitorStore;
import com.gitee.easyopen.monitor.MonitorInterceptor;
import com.gitee.easyopen.monitor.MonitorStore;
import com.gitee.easyopen.permission.PermissionManager;
import com.gitee.easyopen.serializer.JsonResultSerializer;
import com.gitee.easyopen.serializer.XmlResultSerializer;
import com.gitee.easyopen.session.ApiSessionManager;
import com.gitee.easyopen.session.SessionManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class ApiConfig {
    private Encrypter encrypter = new ApiEncrypter();
    private AppSecretManager appSecretManager = new CacheAppSecretManager();
    private ResultCreator resultCreator = new ApiResultCreator();
    private ResultSerializer jsonResultSerializer = new JsonResultSerializer();
    private ResultSerializer xmlResultSerializer = new XmlResultSerializer();
    private Signer signer = new ApiSigner();
    private RespWriter respWriter = new ApiRespWriter();
    private ParamParser paramParser = new ApiParamParser();
    private SessionManager sessionManager = new ApiSessionManager();
    private ApiInterceptor[] interceptors = new ApiInterceptor[0];
    private Oauth2Service oauth2Service = new Oauth2ServiceImpl();
    private MonitorStore monitorStore = new ApiMonitorStore();
    private List<String> isvModules = new ArrayList<String>();
    private DataDecoder dataDecoder = new ApiDataDecoder();
    private ApiRegistEvent apiRegistEvent = new ApiRegistEvent(){

        @Override
        public void onSuccess(ApiDefinition apiDefinition) {
        }
    };
    private ApiInterceptor monitorInerceptor = new MonitorInterceptor();
    private Validator validator = new ApiValidator();
    private JwtService jwtService = new JwtServiceImpl();
    private Invoker invoker = new ApiInvoker();
    private Oauth2Manager oauth2Manager;
    private LimitManager limitManager;
    private LimitConfigManager limitConfigManager;
    private PermissionManager permissionManager;
    private DocFileCreator docFileCreator;
    private Function<Throwable, Throwable> exceptionFormatter = Function.identity();
    private String appName = "app";
    private String defaultVersion = "";
    private Integer timeoutSeconds = 3;
    private Boolean showDoc = false;
    private String docPassword;
    private String docClassPath = "/easyopen_template/doc.html";
    private String docPdfClassPath = "/easyopen_template/docPdf.html";
    private String docPdfCssClassPath = "/easyopen_template/docPdf.css";
    private String monitorClassPath = "/easyopen_template/monitor.html";
    private String loginClassPath = "/easyopen_template/login.html";
    private String limitClassPath = "/easyopen_template/limit.html";
    private String limitPassword = "limit123";
    private LimitType defaultLimitType = LimitType.LIMIT;
    private Integer defaultLimitCount = 50;
    private Integer defaultTokenBucketCount = 50;
    private static String CONFIG_FOLDER = System.getProperty("user.dir") + File.separator + "local-config" + File.separator;
    private String localLimitConfigFile;
    private String localPermissionConfigFile;
    private String localSecretConfigFile;
    private ConfigClient configClient;
    private Boolean ignoreValidate = false;
    private String oauth2LoginUri = "/oauth2login";
    private Long oauth2ExpireIn = 7200L;
    private Integer jwtExpireIn = 7200;
    private String privateKey;
    private String priKeyPath = "/pri.key";
    private Boolean showMonitor = true;
    private String monitorPassword = "monitor123";
    private Integer monitorErrorQueueSize = 5;
    private Integer monitorExecutorSize = 2;
    private Class<? extends Result> wrapperClass;
    private String jwtSecret = "#56gu25@41tCVr]>0$";
    private String markdownDocDir;

    public ApiConfig() {
        this.isvModules.add("i18n/isv/error");
    }

    public void setAppName(String appName) {
        this.appName = appName;
        if (this.localLimitConfigFile == null) {
            this.localLimitConfigFile = System.getProperty("conflimit.file", CONFIG_FOLDER + appName + "-limit.json");
        }
        if (this.localPermissionConfigFile == null) {
            this.localPermissionConfigFile = System.getProperty("confperm.file", CONFIG_FOLDER + appName + "-permission.json");
        }
        if (this.localSecretConfigFile == null) {
            this.localSecretConfigFile = System.getProperty("confsecret.file", CONFIG_FOLDER + appName + "-secret.json");
        }
    }

    public void openAppMode() {
        this.timeoutSeconds = 0;
    }

    public Encrypter getEncrypter() {
        return this.encrypter;
    }

    public void setEncrypter(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public void loadPrivateKey() {
        ClassPathResource res = new ClassPathResource(this.priKeyPath);
        if (res.exists()) {
            try {
                this.privateKey = IOUtils.toString((InputStream)res.getInputStream(), (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initOauth2Service(Oauth2Manager oauth2Manager) {
        this.oauth2Manager = oauth2Manager;
        this.oauth2Service.setOauth2Manager(oauth2Manager);
    }

    public Boolean getShowDoc() {
        return this.showDoc;
    }

    public void setShowDoc(Boolean showDoc) {
        this.showDoc = showDoc;
    }

    public Boolean getShowMonitor() {
        return this.showMonitor;
    }

    public void setShowMonitor(Boolean showMonitor) {
        this.showMonitor = showMonitor;
    }

    public void addAppSecret(Map<String, String> appSecretStore) {
        this.appSecretManager.addAppSecret(appSecretStore);
    }

    public void setAppSecret(Map<String, String> appSecret) {
        this.addAppSecret(appSecret);
    }

    public AppSecretManager getAppSecretManager() {
        return this.appSecretManager;
    }

    public void setAppSecretManager(AppSecretManager appSecretManager) {
        this.appSecretManager = appSecretManager;
    }

    public ResultCreator getResultCreator() {
        return this.resultCreator;
    }

    public void setResultCreator(ResultCreator resultCreator) {
        this.resultCreator = resultCreator;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public ResultSerializer getJsonResultSerializer() {
        return this.jsonResultSerializer;
    }

    public void setJsonResultSerializer(ResultSerializer jsonResultSerializer) {
        this.jsonResultSerializer = jsonResultSerializer;
    }

    public ResultSerializer getXmlResultSerializer() {
        return this.xmlResultSerializer;
    }

    public void setXmlResultSerializer(ResultSerializer xmlResultSerializer) {
        this.xmlResultSerializer = xmlResultSerializer;
    }

    public List<String> getIsvModules() {
        return this.isvModules;
    }

    public void setIsvModules(List<String> isvModules) {
        this.isvModules = isvModules;
    }

    public Boolean getIgnoreValidate() {
        return this.ignoreValidate;
    }

    public void setIgnoreValidate(Boolean ignoreValidate) {
        this.ignoreValidate = ignoreValidate;
    }

    public RespWriter getRespWriter() {
        return this.respWriter;
    }

    public void setRespWriter(RespWriter respWriter) {
        this.respWriter = respWriter;
    }

    public String getOauth2LoginUri() {
        return this.oauth2LoginUri;
    }

    public void setOauth2LoginUri(String oauth2LoginUri) {
        this.oauth2LoginUri = oauth2LoginUri;
    }

    public Long getOauth2ExpireIn() {
        return this.oauth2ExpireIn;
    }

    public void setOauth2ExpireIn(Long oauth2ExpireIn) {
        this.oauth2ExpireIn = oauth2ExpireIn;
    }

    public Oauth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    public void setOauth2Service(Oauth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    public Oauth2Manager getOauth2Manager() {
        return this.oauth2Manager;
    }

    public void setOauth2Manager(Oauth2Manager oauth2Manager) {
        this.oauth2Manager = oauth2Manager;
    }

    public Integer getJwtExpireIn() {
        return this.jwtExpireIn;
    }

    public void setJwtExpireIn(Integer jwtExpireIn) {
        this.jwtExpireIn = jwtExpireIn;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    public ApiInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(ApiInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public ParamParser getParamParser() {
        return this.paramParser;
    }

    public void setParamParser(ParamParser paramParser) {
        this.paramParser = paramParser;
    }

    public String getPriKeyPath() {
        return this.priKeyPath;
    }

    public void setPriKeyPath(String priKeyPath) {
        this.priKeyPath = priKeyPath;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String getDocClassPath() {
        return this.docClassPath;
    }

    public void setDocClassPath(String docClassPath) {
        this.docClassPath = docClassPath;
    }

    public MonitorStore getMonitorStore() {
        return this.monitorStore;
    }

    public void setMonitorStore(MonitorStore monitorStore) {
        this.monitorStore = monitorStore;
    }

    public ApiInterceptor getMonitorInerceptor() {
        return this.monitorInerceptor;
    }

    public void setMonitorInerceptor(ApiInterceptor monitorInerceptor) {
        this.monitorInerceptor = monitorInerceptor;
    }

    public String getMonitorClassPath() {
        return this.monitorClassPath;
    }

    public void setMonitorClassPath(String monitorClassPath) {
        this.monitorClassPath = monitorClassPath;
    }

    public Integer getMonitorErrorQueueSize() {
        return this.monitorErrorQueueSize;
    }

    public void setMonitorErrorQueueSize(Integer monitorErrorQueueSize) {
        this.monitorErrorQueueSize = monitorErrorQueueSize;
    }

    public Integer getMonitorExecutorSize() {
        return this.monitorExecutorSize;
    }

    public void setMonitorExecutorSize(Integer monitorExecutorSize) {
        this.monitorExecutorSize = monitorExecutorSize;
    }

    public String getMonitorPassword() {
        return this.monitorPassword;
    }

    public void setMonitorPassword(String monitorPassword) {
        this.monitorPassword = monitorPassword;
    }

    public String getLoginClassPath() {
        return this.loginClassPath;
    }

    public void setLoginClassPath(String loginClassPath) {
        this.loginClassPath = loginClassPath;
    }

    public String getDocPassword() {
        return this.docPassword;
    }

    public void setDocPassword(String docPassword) {
        this.docPassword = docPassword;
    }

    public LimitManager getLimitManager() {
        return this.limitManager;
    }

    public void setLimitManager(LimitManager limitManager) {
        this.limitManager = limitManager;
        this.limitConfigManager = limitManager.getLimitConfigManager();
    }

    public LimitConfigManager getLimitConfigManager() {
        return this.limitConfigManager;
    }

    public void setLimitConfigManager(LimitConfigManager limitConfigManager) {
        this.limitConfigManager = limitConfigManager;
    }

    public String getLimitClassPath() {
        return this.limitClassPath;
    }

    public void setLimitClassPath(String limitClassPath) {
        this.limitClassPath = limitClassPath;
    }

    public String getLimitPassword() {
        return this.limitPassword;
    }

    public void setLimitPassword(String limitPassword) {
        this.limitPassword = limitPassword;
    }

    public LimitType getDefaultLimitType() {
        return this.defaultLimitType;
    }

    public void setDefaultLimitType(LimitType defaultLimitType) {
        this.defaultLimitType = defaultLimitType;
    }

    public Integer getDefaultLimitCount() {
        return this.defaultLimitCount;
    }

    public void setDefaultLimitCount(Integer defaultLimitCount) {
        this.defaultLimitCount = defaultLimitCount;
    }

    public Integer getDefaultTokenBucketCount() {
        return this.defaultTokenBucketCount;
    }

    public void setDefaultTokenBucketCount(Integer defaultTokenBucketCount) {
        this.defaultTokenBucketCount = defaultTokenBucketCount;
    }

    public String getAppName() {
        return this.appName;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public String getLocalLimitConfigFile() {
        return this.localLimitConfigFile;
    }

    public void setLocalLimitConfigFile(String localLimitConfigFile) {
        this.localLimitConfigFile = localLimitConfigFile;
    }

    public String getLocalPermissionConfigFile() {
        return this.localPermissionConfigFile;
    }

    public void setLocalPermissionConfigFile(String localPermissionConfigFile) {
        this.localPermissionConfigFile = localPermissionConfigFile;
    }

    public ConfigClient getConfigClient() {
        return this.configClient;
    }

    public void setConfigClient(ConfigClient configClient) {
        this.configClient = configClient;
    }

    public String getLocalSecretConfigFile() {
        return this.localSecretConfigFile;
    }

    public void setLocalSecretConfigFile(String localSecretConfigFile) {
        this.localSecretConfigFile = localSecretConfigFile;
    }

    public String getDocPdfClassPath() {
        return this.docPdfClassPath;
    }

    public void setDocPdfClassPath(String docPdfClassPath) {
        this.docPdfClassPath = docPdfClassPath;
    }

    public String getDocPdfCssClassPath() {
        return this.docPdfCssClassPath;
    }

    public void setDocPdfCssClassPath(String docPdfCssClassPath) {
        this.docPdfCssClassPath = docPdfCssClassPath;
    }

    public Class<? extends Result> getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(Class<? extends Result> wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public DataDecoder getDataDecoder() {
        return this.dataDecoder;
    }

    public void setDataDecoder(DataDecoder dataDecoder) {
        this.dataDecoder = dataDecoder;
    }

    public String getJwtSecret() {
        return this.jwtSecret;
    }

    public void setJwtSecret(String jwtSecret) {
        this.jwtSecret = jwtSecret;
    }

    public ApiRegistEvent getApiRegistEvent() {
        return this.apiRegistEvent;
    }

    public void setApiRegistEvent(ApiRegistEvent apiRegistEvent) {
        this.apiRegistEvent = apiRegistEvent;
    }

    public void setApiName(String apiName) {
        ParamNames.API_NAME = apiName;
    }

    public void setVersionName(String versionName) {
        ParamNames.VERSION_NAME = versionName;
    }

    public void setAppKeyName(String appKeyName) {
        ParamNames.APP_KEY_NAME = appKeyName;
    }

    public void setDataName(String dataName) {
        ParamNames.DATA_NAME = dataName;
    }

    public void setTimestampName(String timestampName) {
        ParamNames.TIMESTAMP_NAME = timestampName;
    }

    public void setSignName(String signName) {
        ParamNames.SIGN_NAME = signName;
    }

    public String getMarkdownDocDir() {
        return this.markdownDocDir;
    }

    public void setMarkdownDocDir(String markdownDocDir) {
        this.markdownDocDir = markdownDocDir;
    }

    public DocFileCreator getDocFileCreator() {
        return this.docFileCreator;
    }

    public void setDocFileCreator(DocFileCreator docFileCreator) {
        this.docFileCreator = docFileCreator;
    }

    public Function<Throwable, Throwable> getExceptionFormatter() {
        return this.exceptionFormatter;
    }

    public void setExceptionFormatter(Function<Throwable, Throwable> exceptionFormatter) {
        this.exceptionFormatter = exceptionFormatter;
    }
}

