/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.auth0.jwt.interfaces.Claim;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiMeta;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.Encrypter;
import com.gitee.easyopen.UploadContext;
import com.gitee.easyopen.auth.Oauth2Manager;
import com.gitee.easyopen.auth.OpenUser;
import com.gitee.easyopen.bean.RequestMode;
import com.gitee.easyopen.jwt.JwtService;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.session.SessionManager;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApiContext {
    private static Logger logger = LoggerFactory.getLogger(ApiContext.class);
    private static final String CLASS_NAME = ApiContext.class.getName();
    private static final String NEW_SSL_KEY = CLASS_NAME + "new_ssl_key";
    private static final String ATTR_PARAM = CLASS_NAME + "param";
    private static final String ATTR_API_META = CLASS_NAME + "apimeta";
    private static final String ATTR_JWT_DATA = CLASS_NAME + "jwtdata";
    private static final String ATTR_REQUEST_MODE = CLASS_NAME + "requestmode";
    private static final String ATTR_UPLOAD_CONTEXT = CLASS_NAME + "uploadcontext";
    private static final String ATTR_MSG = CLASS_NAME + "result_msg";
    private static ThreadLocal<HttpServletRequest> request = new InheritableThreadLocal<HttpServletRequest>();
    private static ThreadLocal<HttpServletResponse> response = new InheritableThreadLocal<HttpServletResponse>();
    private static ApplicationContext applicationContext;
    private static ServletContext servletContext;
    private static ApiConfig apiConfig;

    private ApiContext() {
    }

    public static String getAppName() {
        return apiConfig.getAppName();
    }

    public static void setMsg(String msg) {
        ApiContext.setAttr(ATTR_MSG, msg);
    }

    public static String getMsg() {
        Object msg = ApiContext.getAttr(ATTR_MSG);
        return msg == null ? null : msg.toString();
    }

    public static void setAttr(String name, Object val) {
        HttpServletRequest request = ApiContext.getRequest();
        if (request != null) {
            request.setAttribute(name, val);
        }
    }

    public static Object getAttr(String name) {
        HttpServletRequest request = ApiContext.getRequest();
        if (request == null) {
            return null;
        }
        return request.getAttribute(name);
    }

    public static String getRandomKey() {
        HttpSession session = ApiContext.getSession();
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("ssl_randomKey");
    }

    public static void setRequestMode(RequestMode mode) {
        ApiContext.setAttr(ATTR_REQUEST_MODE, (Object)mode);
    }

    public static String decryptAES(String value) {
        String randomKey = ApiContext.getRandomKey();
        try {
            Encrypter encrypter = apiConfig.getEncrypter();
            return encrypter.aesDecryptFromHex(value, randomKey);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw Errors.ERROR_SSL.getException(new Object[0]);
        }
    }

    public static String decryptAESFromBase64String(String value) {
        if (value == null) {
            logger.error("aes value is null");
            throw Errors.ERROR_SSL.getException(new Object[0]);
        }
        String randomKey = ApiContext.getRandomKey();
        try {
            if (randomKey == null) {
                throw new NullPointerException("randomKey is null");
            }
            Encrypter encrypter = apiConfig.getEncrypter();
            return encrypter.aesDecryptFromBase64String(value, randomKey);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw Errors.ERROR_SSL.getException(new Object[0]);
        }
    }

    public static boolean isEncryptMode() {
        RequestMode mode = (RequestMode)((Object)ApiContext.getAttr(ATTR_REQUEST_MODE));
        if (mode == null) {
            return false;
        }
        return RequestMode.ENCRYPT == mode;
    }

    public static String createJwt(Map<String, String> data) {
        Assert.notNull((Object)apiConfig, (String)"apiConfig\u5c1a\u672a\u521d\u59cb\u5316");
        JwtService jwtService = apiConfig.getJwtService();
        return jwtService.createJWT(data);
    }

    public static Map<String, Claim> getJwtData() {
        return (Map)ApiContext.getAttr(ATTR_JWT_DATA);
    }

    public static void setJwtData(Map<String, Claim> data) {
        ApiContext.setAttr(ATTR_JWT_DATA, data);
    }

    public static OpenUser getAccessTokenUser() {
        String accessToken = ApiContext.getSessionId();
        if (StringUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        Oauth2Manager manager = apiConfig.getOauth2Manager();
        return manager.getUserByAccessToken(accessToken);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes atri;
        HttpServletRequest req = request.get();
        if (req == null && (atri = RequestContextHolder.getRequestAttributes()) != null) {
            req = ((ServletRequestAttributes)atri).getRequest();
        }
        return req;
    }

    public static HttpSession getSession() {
        HttpServletRequest req = ApiContext.getRequest();
        if (req == null) {
            return null;
        }
        return req.getSession();
    }

    public static SessionManager getSessionManager() {
        return apiConfig.getSessionManager();
    }

    public static HttpSession getManagedSession() {
        String sessionId = ApiContext.getSessionId();
        if (sessionId != null) {
            return ApiContext.getSessionManager().getSession(sessionId);
        }
        return null;
    }

    public static String getAccessToken() {
        return ApiContext.getSessionId();
    }

    public static String getSessionId() {
        ApiParam apiParam = ApiContext.getApiParam();
        if (apiParam == null) {
            return null;
        }
        return apiParam.fatchAccessToken();
    }

    public static void setRequest(HttpServletRequest req) {
        request.set(req);
    }

    public static Locale getLocal() {
        HttpServletRequest req = ApiContext.getRequest();
        if (req == null) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return req.getLocale();
    }

    public static void setApiParam(ApiParam apiParam) {
        ApiContext.setAttr(ATTR_PARAM, apiParam);
    }

    public static ApiParam getApiParam() {
        return (ApiParam)ApiContext.getAttr(ATTR_PARAM);
    }

    public static ApiConfig getApiConfig() {
        return apiConfig;
    }

    public static void setApiConfig(ApiConfig apiConfig) {
        ApiContext.apiConfig = apiConfig;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        ApiContext.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableWebApplicationContext) {
            servletContext = ((ConfigurableWebApplicationContext)applicationContext).getServletContext();
        }
    }

    public static ServletContext getServletContext() {
        if (servletContext != null) {
            return servletContext;
        }
        ServletContext ctx = null;
        HttpSession session = ApiContext.getSession();
        if (session != null) {
            ctx = session.getServletContext();
        }
        return ctx;
    }

    public static UploadContext getUploadContext() {
        return (UploadContext)ApiContext.getAttr(ATTR_UPLOAD_CONTEXT);
    }

    public static void setUploadContext(UploadContext uploadCtx) {
        ApiContext.setAttr(ATTR_UPLOAD_CONTEXT, uploadCtx);
    }

    public static void useNewSSL(HttpServletRequest request) {
        request.setAttribute(NEW_SSL_KEY, (Object)true);
    }

    public static boolean hasUseNewSSL(HttpServletRequest request) {
        return request.getAttribute(NEW_SSL_KEY) != null;
    }

    public static void clean() {
        request.remove();
        response.remove();
    }

    public static void setResponse(HttpServletResponse resp) {
        response.set(resp);
    }

    public static HttpServletResponse getResponse() {
        return response.get();
    }

    public static void setApiMeta(ApiMeta apiMeta) {
        ApiContext.setAttr(ATTR_API_META, apiMeta);
    }

    public static ApiMeta getApiMeta() {
        return (ApiMeta)ApiContext.getAttr(ATTR_API_META);
    }

    static {
        apiConfig = new ApiConfig();
    }
}

