/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.interfaces.Claim;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.Invoker;
import com.gitee.easyopen.Result;
import com.gitee.easyopen.UploadContext;
import com.gitee.easyopen.Validator;
import com.gitee.easyopen.bean.ApiDefinition;
import com.gitee.easyopen.bean.ApiInvocation;
import com.gitee.easyopen.bean.Callers;
import com.gitee.easyopen.bean.DefinitionHolder;
import com.gitee.easyopen.bean.MethodCaller;
import com.gitee.easyopen.doc.ApiDocHolder;
import com.gitee.easyopen.doc.ApiDocItem;
import com.gitee.easyopen.exception.BusinessParamException;
import com.gitee.easyopen.interceptor.ApiInterceptor;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.register.SingleParameterContext;
import com.gitee.easyopen.util.CopyUtil;
import com.gitee.easyopen.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ApiInvoker
implements Invoker {
    private static final Logger logger = LoggerFactory.getLogger(ApiInvoker.class);
    private static final Logger param_log = LoggerFactory.getLogger(BusinessParamException.class);
    private static final ApiInterceptor[] EMPTY_INTERCEPTOR_ARRAY = new ApiInterceptor[0];
    private static final EmptyObject EMPTY_OBJECT = new EmptyObject();

    @Override
    public Object invoke(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ApiContext.setRequest(request);
        ApiContext.setResponse(response);
        try {
            ApiParam param = ApiContext.getApiConfig().getParamParser().parse(request);
            ApiContext.setApiParam(param);
            return this.doInvoke(param, request, response);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            this.logError(e);
            throw e;
        }
    }

    @Override
    public Object invokeMock(HttpServletRequest request, HttpServletResponse response) {
        ApiContext.setRequest(request);
        ApiContext.setResponse(response);
        ApiParam param = ApiContext.getApiConfig().getParamParser().parse(request);
        ApiContext.setApiParam(param);
        ApiDocItem apiDocItem = ApiDocHolder.getApiDocBuilder().getApiDocItem(param.fatchName(), param.fatchVersion());
        if (apiDocItem == null) {
            return EMPTY_OBJECT;
        }
        Object resultData = apiDocItem.fatchResultData();
        if (resultData == null) {
            resultData = EMPTY_OBJECT;
        }
        return resultData;
    }

    protected void logError(Throwable e) {
        if (e instanceof BusinessParamException) {
            BusinessParamException ex = (BusinessParamException)e;
            param_log.warn("\u4e1a\u52a1\u53c2\u6570\u9519\u8bef,code:{}, msg:{}", (Object)ex.getCode(), (Object)ex.getMessage());
        } else {
            logger.error(e.getMessage(), e);
        }
    }

    protected void initJwtInfo(HttpServletRequest request, ApiParam param) {
        Map<String, Claim> data = null;
        String jwt = this.getHeader(request, "Authorization");
        if (jwt != null && jwt.startsWith("Bearer ")) {
            jwt = jwt.replace("Bearer ", "");
            data = ApiContext.getApiConfig().getJwtService().verfiyJWT(jwt);
        }
        ApiContext.setJwtData(data);
    }

    protected String getHeader(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value == null) {
            return null;
        }
        if (ApiContext.isEncryptMode()) {
            value = ApiContext.decryptAES(value);
        } else if (ApiContext.hasUseNewSSL(request)) {
            value = ApiContext.decryptAESFromBase64String(value);
        }
        return value;
    }

    protected Object doInvoke(ApiParam param, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ApiDefinition apiDefinition = this.getApiDefinition(param);
        ApiContext.setApiMeta(apiDefinition);
        if (!apiDefinition.isIgnoreJWT()) {
            this.initJwtInfo(request, param);
        }
        Object methodArgu = null;
        Object invokeResult = null;
        Validator validator = ApiContext.getApiConfig().getValidator();
        param.setIgnoreSign(apiDefinition.isIgnoreSign());
        param.setIgnoreValidate(apiDefinition.isIgnoreValidate());
        validator.validate(param);
        String busiJsonData = ApiContext.getApiConfig().getDataDecoder().decode(param);
        Class<?> arguClass = apiDefinition.getMethodArguClass();
        boolean isSingleParameter = apiDefinition.isSingleParameter();
        Object singleParamProxy = null;
        int interceptorIndex = 0;
        try {
            ApiInterceptor[] interceptors;
            if (arguClass != null) {
                if (arguClass == JSONObject.class) {
                    methodArgu = JSON.parseObject((String)busiJsonData);
                } else if (arguClass == Map.class) {
                    methodArgu = new HashMap(JSON.parseObject((String)busiJsonData));
                } else if (isSingleParameter) {
                    SingleParameterContext.SingleParameterContextValue value = SingleParameterContext.get(param.fatchName(), param.fatchVersion());
                    if (value != null) {
                        JSONObject jsonObj = JSON.parseObject((String)busiJsonData);
                        methodArgu = jsonObj.getObject(value.getParamName(), arguClass);
                        singleParamProxy = jsonObj.toJavaObject(value.getWrapClass());
                    }
                } else {
                    methodArgu = JSON.parseObject((String)busiJsonData, arguClass);
                }
                this.bindUploadFile(methodArgu);
            }
            if ((interceptors = ApiContext.getApiConfig().getInterceptors()) == null) {
                interceptors = EMPTY_INTERCEPTOR_ARRAY;
            }
            int i = 0;
            while (i < interceptors.length) {
                ApiInterceptor interceptor = interceptors[i];
                if (interceptor.match(apiDefinition) && !interceptor.preHandle(request, response, apiDefinition.getHandler(), methodArgu)) {
                    this.triggerAfterCompletion(apiDefinition, interceptorIndex, request, response, methodArgu, null, null);
                    return null;
                }
                interceptorIndex = i++;
            }
            this.validateBizArgu(validator, methodArgu, singleParamProxy);
            MethodCaller methodCaller = apiDefinition.getMethodCaller();
            invokeResult = methodCaller != null ? methodCaller.call(new ApiInvocation(apiDefinition, methodArgu)) : Callers.call(apiDefinition, methodArgu);
            for (int i2 = interceptors.length - 1; i2 >= 0; --i2) {
                ApiInterceptor interceptor = interceptors[i2];
                if (!interceptor.match(apiDefinition)) continue;
                interceptor.postHandle(request, response, apiDefinition.getHandler(), methodArgu, invokeResult);
            }
            if (invokeResult == null) {
                invokeResult = EMPTY_OBJECT;
            }
            Object finalReturn = this.wrapResult(apiDefinition, invokeResult);
            this.setMsg(finalReturn);
            this.triggerAfterCompletion(apiDefinition, interceptorIndex, request, response, methodArgu, finalReturn, null);
            return finalReturn;
        }
        catch (Exception e) {
            this.triggerAfterCompletion(apiDefinition, interceptorIndex, request, response, methodArgu, invokeResult, e);
            throw e;
        }
    }

    protected void setMsg(Object finalReturn) {
        String msg = ApiContext.getMsg();
        if (msg != null && finalReturn instanceof Result) {
            Result result = (Result)finalReturn;
            result.setMsg(msg);
        }
    }

    protected ApiDefinition getApiDefinition(ApiParam param) {
        ApiDefinition apiDefinition = DefinitionHolder.getByParam(param);
        if (apiDefinition == null) {
            throw Errors.NO_API.getException(new Object[0]);
        }
        return apiDefinition;
    }

    protected Object wrapResult(ApiDefinition apiDefinition, Object invokeResult) {
        Object finalReturn = invokeResult;
        if (apiDefinition.noReturn()) {
            finalReturn = null;
        } else if (apiDefinition.isWrapResult()) {
            finalReturn = ApiContext.getApiConfig().getResultCreator().createResult(invokeResult);
        }
        return finalReturn;
    }

    private void triggerAfterCompletion(ApiDefinition definition, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Object argu, Object result, Exception e) throws Exception {
        ApiInterceptor[] interceptors = ApiContext.getApiConfig().getInterceptors();
        if (interceptors != null && interceptors.length > 0) {
            for (int i = interceptorIndex; i >= 0; --i) {
                ApiInterceptor interceptor = interceptors[i];
                if (!interceptor.match(definition)) continue;
                interceptor.afterCompletion(request, response, definition.getHandler(), argu, result, e);
            }
        }
    }

    protected void validateBizArgu(Validator validator, Object methodArgu, Object singleParamProxy) {
        if (singleParamProxy != null) {
            validator.validateBusiParam(singleParamProxy);
        } else {
            validator.validateBusiParam(methodArgu);
        }
    }

    protected void bindUploadFile(Object methodArgu) {
        List<MultipartFile> files;
        UploadContext uploadContext;
        if (methodArgu != null && (uploadContext = ApiContext.getUploadContext()) != null && (files = uploadContext.getAllFile()) != null && files.size() > 0) {
            HashMap<String, Object> filesMap = new HashMap<String, Object>(files.size());
            for (MultipartFile file : files) {
                filesMap.put(file.getName(), file);
            }
            CopyUtil.copyProperties(filesMap, methodArgu);
            Field field = ReflectionUtil.getListFieldWithGeneric(methodArgu, MultipartFile.class);
            if (field != null) {
                ReflectionUtil.invokeFieldValue(methodArgu, field.getName(), files);
            }
        }
    }

    private static class EmptyObject
    implements Serializable {
        private static final long serialVersionUID = 1713263598232463135L;

        private EmptyObject() {
        }
    }
}

