/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.alibaba.fastjson.JSONObject;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.Param;
import com.gitee.easyopen.ParamNames;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ApiParam
extends JSONObject
implements Param {
    private static final long serialVersionUID = 6718200590738465201L;
    private boolean ignoreSign;
    private boolean ignoreValidate;
    private String restName;
    private String restVersion;

    public ApiParam(Map<String, Object> map) {
        super(map);
    }

    public String fatchSignAndRemove() {
        String sign = this.fatchSign();
        this.remove(ParamNames.SIGN_NAME);
        return sign;
    }

    public HttpServletRequest fatchRequest() {
        return ApiContext.getRequest();
    }

    public boolean fatchIgnoreSign() {
        return this.ignoreSign;
    }

    public void setIgnoreSign(boolean ignoreSign) {
        this.ignoreSign = ignoreSign;
    }

    public boolean fatchIgnoreValidate() {
        return this.ignoreValidate;
    }

    public void setIgnoreValidate(boolean ignoreValidate) {
        this.ignoreValidate = ignoreValidate;
    }

    @Override
    public String fatchName() {
        String name = this.getString(ParamNames.API_NAME);
        if (name == null) {
            name = this.restName;
        }
        return name;
    }

    public void setName(String name) {
        this.restName = name;
    }

    public String fatchNameVersion() {
        return ApiParam.buildNameVersion(this.fatchName(), this.fatchVersion());
    }

    public static String buildNameVersion(String name, String version) {
        if (StringUtils.isEmpty((String)version)) {
            return name;
        }
        return name + version;
    }

    @Override
    public String fatchVersion() {
        String version = this.getString(ParamNames.VERSION_NAME);
        if (version == null) {
            version = this.restVersion;
        }
        return version;
    }

    public void setVersion(String version) {
        this.restVersion = version;
    }

    @Override
    public String fatchAppKey() {
        return this.getString(ParamNames.APP_KEY_NAME);
    }

    public void setAppKey(String appKey) {
        this.put(ParamNames.APP_KEY_NAME, appKey);
    }

    @Override
    public String fatchData() {
        return this.getString(ParamNames.DATA_NAME);
    }

    public void setData(String json) {
        this.put(ParamNames.DATA_NAME, json);
    }

    @Override
    public String fatchTimestamp() {
        return this.getString(ParamNames.TIMESTAMP_NAME);
    }

    public void setTimestamp(String timestamp) {
        this.put(ParamNames.TIMESTAMP_NAME, timestamp);
    }

    @Override
    public String fatchSign() {
        return this.getString(ParamNames.SIGN_NAME);
    }

    public void setSign(String sign) {
        this.put(ParamNames.SIGN_NAME, sign);
    }

    @Override
    public String fatchFormat() {
        String format = this.getString(ParamNames.FORMAT_NAME);
        if (format == null || "".equals(format)) {
            return "json";
        }
        return format;
    }

    public void setFormat(String format) {
        this.put(ParamNames.FORMAT_NAME, format);
    }

    @Override
    public String fatchAccessToken() {
        return this.getString(ParamNames.ACCESS_TOKEN_NAME);
    }

    @Override
    public String fatchSignMethod() {
        String signMethod = this.getString(ParamNames.SIGN_METHOD_NAME);
        if (signMethod == null) {
            return "md5";
        }
        return signMethod;
    }

    public ApiParam clone() {
        ApiParam param = new ApiParam((Map<String, Object>)((Object)this));
        param.ignoreSign = this.ignoreSign;
        param.ignoreValidate = this.ignoreValidate;
        return param;
    }
}

