/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.ApiUploadContext;
import com.gitee.easyopen.ParamNames;
import com.gitee.easyopen.ParamParser;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.util.RequestUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ApiParamParser
implements ParamParser {
    private static final Logger logger = LoggerFactory.getLogger(ApiParamParser.class);
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String UPLOAD_FORM_DATA_NAME = "body_data";
    private static String REQUEST_DATA_NAME = ParamNames.DATA_NAME;

    @Override
    public ApiParam parse(HttpServletRequest request) {
        String requestJson = null;
        try {
            requestJson = this.getJson(request);
        }
        catch (Exception e) {
            logger.error("parse error", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)requestJson)) {
            throw Errors.ERROR_PARAM.getException(new Object[0]);
        }
        if (ApiContext.hasUseNewSSL(request)) {
            requestJson = this.decryptData(requestJson);
        } else if (ApiContext.isEncryptMode()) {
            String randomKey = ApiContext.getRandomKey();
            if (randomKey == null) {
                logger.error("\u672a\u627e\u5230randomKey");
                throw Errors.ERROR_SSL.getException(new Object[0]);
            }
            requestJson = ApiContext.decryptAES(requestJson);
        }
        ApiParam param = this.jsonToApiParam(requestJson);
        this.bindRestParam(param, request);
        return param;
    }

    private String decryptData(String requestJson) {
        JSONObject result = JSON.parseObject((String)requestJson);
        String data = result.getString(REQUEST_DATA_NAME);
        try {
            data = ApiContext.decryptAESFromBase64String(data);
            result.put(REQUEST_DATA_NAME, (Object)data);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25");
        }
        return result.toJSONString();
    }

    public String getJson(HttpServletRequest request) throws Exception {
        String requestJson = null;
        if (RequestUtil.isGetRequest(request)) {
            Map<String, Object> params = RequestUtil.convertRequestParamsToMap(request);
            requestJson = JSON.toJSONString(params);
        } else {
            String contectType = request.getContentType();
            if (contectType == null) {
                contectType = "";
            }
            if ((contectType = contectType.toLowerCase()).contains(CONTENT_TYPE_JSON) || contectType.contains(CONTENT_TYPE_TEXT)) {
                requestJson = RequestUtil.getText(request);
            } else if (contectType.contains(CONTENT_TYPE_MULTIPART)) {
                requestJson = this.parseUploadRequest(request);
            } else {
                Map<String, Object> params = RequestUtil.convertRequestParamsToMap(request);
                requestJson = JSON.toJSONString(params);
            }
        }
        return requestJson;
    }

    protected String parseUploadRequest(HttpServletRequest request) {
        String json;
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multiRequest.getFileMap();
            HashMap<String, MultipartFile> finalMap = new HashMap<String, MultipartFile>(fileMap.size());
            Set keys = fileMap.keySet();
            for (String name : keys) {
                MultipartFile file = (MultipartFile)fileMap.get(name);
                if (file.getSize() <= 0L) continue;
                finalMap.put(name, file);
            }
            if (finalMap.size() > 0) {
                ApiContext.setUploadContext(new ApiUploadContext(finalMap));
            }
        }
        if ((json = request.getParameter(UPLOAD_FORM_DATA_NAME)) != null) {
            return json;
        }
        Map<String, Object> params = RequestUtil.convertRequestParamsToMap(request);
        return JSON.toJSONString(params);
    }

    protected ApiParam jsonToApiParam(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            throw Errors.ERROR_PARAM.getException(new Object[0]);
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)json);
        }
        catch (Exception e) {
            throw Errors.ERROR_JSON_DATA.getException(e.getMessage());
        }
        return new ApiParam((Map<String, Object>)jsonObject);
    }

    protected void bindRestParam(ApiParam param, HttpServletRequest request) {
        String name = (String)request.getAttribute("_REST_PARAM_NAME_");
        String version = (String)request.getAttribute("_REST_PARAM_VERSION_");
        if (name != null) {
            param.setName(name);
        }
        if (version != null) {
            param.setVersion(version);
        }
    }
}

