/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.RespWriter;
import com.gitee.easyopen.message.Errors;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRespWriter
implements RespWriter {
    private static Logger logger = LoggerFactory.getLogger(ApiRespWriter.class);
    private static Map<String, String> contentTypeMap = new HashMap<String, String>();

    private static String getContentType(String format) {
        return contentTypeMap.get(format.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(HttpServletRequest request, HttpServletResponse response, Object result) {
        boolean isEncryptMode;
        if (result == null) {
            return;
        }
        ApiConfig apiConfig = ApiContext.getApiConfig();
        ApiParam param = ApiContext.getApiParam();
        String format = param == null ? "json" : param.fatchFormat();
        String returnText = "";
        if ("json".equalsIgnoreCase(format)) {
            returnText = apiConfig.getJsonResultSerializer().serialize(result);
        } else {
            if (!"xml".equalsIgnoreCase(format)) throw Errors.NO_FORMATTER.getException(format);
            returnText = apiConfig.getXmlResultSerializer().serialize(result);
        }
        boolean bl = isEncryptMode = ApiContext.isEncryptMode() || ApiContext.hasUseNewSSL(request);
        if (isEncryptMode) {
            String randomKey = ApiContext.getRandomKey();
            if (randomKey == null) throw Errors.ERROR_SSL.getException(new Object[0]);
            try {
                String text = apiConfig.getEncrypter().aesEncryptToBase64String(returnText, randomKey);
                this.writeText(response, text);
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.writeText(response, e.getMessage());
            }
            return;
        } else {
            String contentType = ApiRespWriter.getContentType(format);
            ApiRespWriter.doWriter(response, contentType, returnText);
        }
    }

    public void writeText(HttpServletResponse response, String text) {
        ApiRespWriter.doWriter(response, "text/plain", text);
    }

    public static void doWriter(HttpServletResponse response, String contentType, String text) {
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            logger.error("doWriter", (Throwable)e);
        }
    }

    static {
        contentTypeMap.put("json".toLowerCase(), "application/json;charset=UTF-8");
        contentTypeMap.put("xml".toLowerCase(), "application/xml");
    }
}

