/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.ParamNames;
import com.gitee.easyopen.Signer;
import com.gitee.easyopen.UploadContext;
import com.gitee.easyopen.Validator;
import com.gitee.easyopen.exception.BusinessParamException;
import com.gitee.easyopen.message.ErrorFactory;
import com.gitee.easyopen.message.Errors;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ApiValidator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(ApiValidator.class);
    private static final int MILLISECOND_OF_ONE_SECOND = 1000;
    private static final String LEFT_TOKEN = "{";
    private static final String RIGHT_TOKEN = "}";
    private static List<String> FORMAT_LIST = Arrays.asList("json", "xml");
    private static Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static final List<String> SYSTEM_PACKAGE_LIST = Arrays.asList("java.lang", "java.math", "java.util", "sun.util");
    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    private static javax.validation.Validator validator = factory.getValidator();

    @Override
    public void validate(ApiParam param) {
        if (ApiContext.getApiConfig().getIgnoreValidate().booleanValue() || param.fatchIgnoreValidate()) {
            logger.debug("\u5ffd\u7565\u6240\u6709\u9a8c\u8bc1(ignoreValidate=true), name:{}, version:{}", (Object)param.fatchName(), (Object)param.fatchVersion());
            return;
        }
        Assert.notNull((Object)ApiContext.getApiConfig().getAppSecretManager(), (String)"appSecretManager\u672a\u521d\u59cb\u5316");
        if (param.fatchIgnoreSign() || ApiContext.isEncryptMode()) {
            logger.debug("\u5ffd\u7565\u7b7e\u540d\u9a8c\u8bc1, name:{}, version:{}", (Object)param.fatchName(), (Object)param.fatchVersion());
        } else {
            this.checkAppKey(param);
            this.checkSign(param);
        }
        this.checkUploadFile(param);
        this.checkTimeout(param);
        this.checkFormat(param);
    }

    protected void checkUploadFile(ApiParam param) {
        UploadContext uploadContext = ApiContext.getUploadContext();
        if (uploadContext != null) {
            try {
                List<MultipartFile> files = uploadContext.getAllFile();
                for (MultipartFile file : files) {
                    String fileMd5;
                    String clientMd5 = param.getString(file.getName());
                    if (clientMd5 == null || clientMd5.equals(fileMd5 = DigestUtils.md5Hex((byte[])file.getBytes()))) continue;
                    throw Errors.ERROR_UPLOAD_FILE.getException(new Object[0]);
                }
            }
            catch (IOException e) {
                logger.error("\u9a8c\u8bc1\u4e0a\u4f20\u6587\u4ef6MD5\u9519\u8bef", (Throwable)e);
                throw Errors.ERROR_UPLOAD_FILE.getException(new Object[0]);
            }
        }
    }

    protected void checkTimeout(ApiParam param) {
        int timeoutSeconds = ApiContext.getApiConfig().getTimeoutSeconds();
        if (timeoutSeconds == 0) {
            return;
        }
        if (timeoutSeconds < 0) {
            throw new IllegalArgumentException("\u670d\u52a1\u7aeftimeoutSeconds\u8bbe\u7f6e\u9519\u8bef");
        }
        String requestTime = param.fatchTimestamp();
        try {
            Date requestDate = new SimpleDateFormat(ParamNames.TIMESTAMP_PATTERN).parse(requestTime);
            long requestMilliseconds = requestDate.getTime();
            if (System.currentTimeMillis() - requestMilliseconds > (long)(timeoutSeconds * 1000)) {
                throw Errors.TIMEOUT.getException(param.fatchNameVersion(), timeoutSeconds);
            }
        }
        catch (ParseException e) {
            throw Errors.TIME_INVALID.getException(param.fatchNameVersion());
        }
    }

    protected void checkAppKey(ApiParam param) {
        Assert.notNull((Object)ApiContext.getApiConfig().getAppSecretManager(), (String)"appSecretManager\u672a\u521d\u59cb\u5316");
        if (StringUtils.isEmpty((Object)param.fatchAppKey())) {
            throw Errors.NO_APP_ID.getException(param.fatchNameVersion(), ParamNames.APP_KEY_NAME);
        }
        boolean isTrueAppKey = ApiContext.getApiConfig().getAppSecretManager().isValidAppKey(param.fatchAppKey());
        if (!isTrueAppKey) {
            throw Errors.ERROR_APP_ID.getException(param.fatchNameVersion(), ParamNames.APP_KEY_NAME);
        }
    }

    protected void checkSign(ApiParam param) {
        if (StringUtils.isEmpty((Object)param.fatchSign())) {
            throw Errors.NO_SIGN_PARAM.getException(param.fatchNameVersion(), ParamNames.SIGN_NAME);
        }
        String secret = ApiContext.getApiConfig().getAppSecretManager().getSecret(param.fatchAppKey());
        Signer signer = ApiContext.getApiConfig().getSigner();
        boolean isRightSign = signer.isRightSign(param, secret, param.fatchSignMethod());
        if (!isRightSign) {
            throw Errors.ERROR_SIGN.getException(param.fatchNameVersion());
        }
    }

    protected void checkFormat(ApiParam param) {
        String format = param.fatchFormat();
        boolean contains = FORMAT_LIST.contains(format.toLowerCase());
        if (!contains) {
            throw Errors.NO_FORMATTER.getException(param.fatchNameVersion(), format);
        }
    }

    @Override
    public void validateBusiParam(Object obj) {
        Set set;
        if (obj == null) {
            return;
        }
        List<Object> fields = this.listObjectField(obj);
        if (!fields.isEmpty()) {
            fields.forEach(this::validateBusiParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)(set = validator.validate(obj, new Class[0])))) {
            ConstraintViolation oneError = (ConstraintViolation)set.iterator().next();
            String errorMsg = oneError.getMessage();
            throw this.getValidateBusiParamException(errorMsg);
        }
    }

    private List<Object> listObjectField(Object object) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ReflectionUtils.doWithFields(object.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            ret.add(field.get(object));
        }, this::isMatchField);
        return ret;
    }

    private boolean isMatchField(Field field) {
        boolean isAssignableFrom;
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            return false;
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return false;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        boolean isSame = declaringClass == fieldType;
        boolean bl = isAssignableFrom = declaringClass.isAssignableFrom(fieldType) || fieldType.isAssignableFrom(declaringClass);
        if (isSame || isAssignableFrom) {
            return false;
        }
        Package aPackage = fieldType.getPackage();
        if (aPackage == null) {
            return false;
        }
        String packageName = aPackage.getName();
        for (String prefix : SYSTEM_PACKAGE_LIST) {
            if (!packageName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private RuntimeException getValidateBusiParamException(String errorMsg) {
        String code = Errors.BUSI_PARAM_ERROR.getCode();
        String[] msgToken = errorMsg.split("=");
        String msg = msgToken[0];
        if (msg.startsWith(LEFT_TOKEN) && msg.endsWith(RIGHT_TOKEN)) {
            String module = msg.substring(1, msg.length() - 1);
            Object[] params = this.buildParams(msgToken);
            String error = ErrorFactory.getErrorMessage(module, ApiContext.getLocal(), params);
            return new BusinessParamException(error, code);
        }
        return new BusinessParamException(errorMsg, code);
    }

    private Object[] buildParams(String[] msgToken) {
        if (msgToken.length == 2) {
            return msgToken[1].split(",");
        }
        return EMPTY_OBJ_ARRAY;
    }

    public static javax.validation.Validator getValidator() {
        return validator;
    }

    public static void setValidator(javax.validation.Validator validator) {
        ApiValidator.validator = validator;
    }
}

