/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.gitee.easyopen.AppSecretManager;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class FileAppSecretManager
implements AppSecretManager {
    private String appSecretFile = "appSecret.properties";
    private Properties properties;

    @Override
    public void addAppSecret(Map<String, String> appSecretStore) {
        this.properties.putAll(appSecretStore);
    }

    @Override
    public String getSecret(String appKey) {
        if (this.properties == null) {
            try {
                DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
                Resource resource = resourceLoader.getResource(this.appSecretFile);
                this.properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            }
            catch (IOException e) {
                throw new RuntimeException("\u5728\u7c7b\u8def\u5f84\u4e0b\u627e\u4e0d\u5230appSecret.properties\u7684\u5e94\u7528\u5bc6\u94a5\u7684\u5c5e\u6027\u6587\u4ef6");
            }
        }
        return this.properties.getProperty(appKey);
    }

    public void setAppSecretFile(String appSecretFile) {
        this.appSecretFile = appSecretFile;
    }

    @Override
    public boolean isValidAppKey(String appKey) {
        if (appKey == null) {
            return false;
        }
        return this.getSecret(appKey) != null;
    }
}

