/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.AppSecretManager;
import com.gitee.easyopen.ManagerInitializer;
import com.gitee.easyopen.bean.Secret;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAppSecretManager
implements AppSecretManager,
ManagerInitializer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Secret> secretMap = new ConcurrentHashMap<String, Secret>(64);

    @Override
    public void loadLocal() {
        try {
            this.logger.info("\u5f00\u59cb\u8bfb\u53d6\u672c\u5730\u79d8\u94a5\u914d\u7f6e\u6587\u4ef6");
            String localFile = ApiContext.getApiConfig().getLocalSecretConfigFile();
            String configJson = FileUtils.readFileToString((File)new File(localFile), (String)"UTF-8");
            this.loadSecretCache(configJson);
            this.logger.info("\u672c\u5730\u79d8\u94a5\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u6210\u529f\uff0c\u8def\u5f84\uff1a{}", (Object)localFile);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u79d8\u94a5\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    public void loadSecretCache(String json) {
        if (StringUtils.isEmpty((String)json)) {
            json = "[]";
        }
        secretMap.clear();
        JSONArray arr = JSON.parseArray((String)json);
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject jsonObj = arr.getJSONObject(i);
            Secret secret = (Secret)jsonObj.toJavaObject(Secret.class);
            secretMap.put(secret.getAppKey(), secret);
        }
    }

    @Override
    public void addAppSecret(Map<String, String> appSecretStore) {
        throw new UnsupportedOperationException("\u65e0\u6548\u64cd\u4f5c\uff0ccom.gitee.easyopen.LocalAppSecretManager.addAppSecret(Map<String, String> appSecretStore)");
    }

    @Override
    public String getSecret(String appKey) {
        if (secretMap.isEmpty()) {
            throw new RuntimeException("\u670d\u52a1\u7aef\u5c1a\u672a\u521d\u59cb\u5316\u79d8\u94a5");
        }
        Secret secret = secretMap.get(appKey);
        if (secret == null) {
            return null;
        }
        return secret.getSecret();
    }

    public Secret getSecretInfo(String appKey) {
        if (StringUtils.isEmpty((String)appKey)) {
            return null;
        }
        if (secretMap.isEmpty()) {
            throw new RuntimeException("\u670d\u52a1\u7aef\u5c1a\u672a\u521d\u59cb\u5316\u79d8\u94a5");
        }
        return secretMap.get(appKey);
    }

    @Override
    public boolean isValidAppKey(String appKey) {
        if (appKey == null) {
            return false;
        }
        return secretMap.containsKey(appKey);
    }
}

