/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.auth.impl;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.auth.Oauth2Manager;
import com.gitee.easyopen.auth.Oauth2Service;
import com.gitee.easyopen.auth.OpenUser;
import com.gitee.easyopen.auth.RefreshToken;
import com.gitee.easyopen.auth.TokenPair;
import com.gitee.easyopen.exception.LoginErrorException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuer;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Oauth2ServiceImpl
implements Oauth2Service {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2ServiceImpl.class);
    private static final String TOKEN_TYPE = "Bearer";
    private OAuthIssuer oauthIssuer = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
    private Oauth2Manager oauth2Manager;

    @Override
    public OAuthResponse authorize(HttpServletRequest request, HttpServletResponse resp, ApiConfig apiConfig) throws URISyntaxException, OAuthSystemException {
        try {
            OAuthAuthzRequest oauthRequest = new OAuthAuthzRequest(request);
            if (!this.checkClientId(oauthRequest.getClientId(), apiConfig)) {
                return OAuthASResponse.errorResponse((int)400).setError("invalid_client").setErrorDescription("invalid_client").buildJSONMessage();
            }
            OpenUser user = null;
            try {
                user = this.oauth2Manager.login(request);
            }
            catch (LoginErrorException e) {
                logger.error(e.getMessage(), (Throwable)e);
                request.setAttribute("error", (Object)e.getMessage());
                try {
                    request.getRequestDispatcher(apiConfig.getOauth2LoginUri()).forward((ServletRequest)request, (ServletResponse)resp);
                    return null;
                }
                catch (Exception e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                    throw new RuntimeException(e1);
                }
            }
            String authorizationCode = null;
            String responseType = oauthRequest.getParam("response_type");
            if (responseType.equals(ResponseType.CODE.toString())) {
                OAuthIssuerImpl oauthIssuerImpl = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
                authorizationCode = oauthIssuerImpl.authorizationCode();
                this.oauth2Manager.addAuthCode(authorizationCode, user);
            }
            OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse((HttpServletRequest)request, (int)302);
            builder.setCode(authorizationCode);
            String redirectURI = oauthRequest.getParam("redirect_uri");
            return builder.location(redirectURI).buildQueryMessage();
        }
        catch (OAuthProblemException e) {
            String redirectUri = e.getRedirectUri();
            if (OAuthUtils.isEmpty((String)redirectUri)) {
                String error = "OAuth redirectUri needs to be provided by client!!!";
                return OAuthASResponse.errorResponse((int)302).error(OAuthProblemException.error((String)error)).location(redirectUri).buildQueryMessage();
            }
            return OAuthASResponse.errorResponse((int)302).error(e).location(redirectUri).buildQueryMessage();
        }
    }

    @Override
    public OAuthResponse accessToken(HttpServletRequest request, ApiConfig apiConfig) throws URISyntaxException, OAuthSystemException {
        try {
            OAuthTokenRequest oauthRequest = new OAuthTokenRequest(request);
            if (!this.checkClientId(oauthRequest.getClientId(), apiConfig)) {
                return OAuthASResponse.errorResponse((int)400).setError("invalid_client").setErrorDescription("invalid_client").buildJSONMessage();
            }
            if (!this.checkClientSecret(oauthRequest.getClientId(), oauthRequest.getClientSecret(), apiConfig)) {
                return OAuthASResponse.errorResponse((int)401).setError("unauthorized_client").setErrorDescription("unauthorized_client").buildJSONMessage();
            }
            String grant_type = oauthRequest.getParam("grant_type");
            if (GrantType.AUTHORIZATION_CODE.toString().equals(grant_type)) {
                String authCode = oauthRequest.getParam("code");
                if (!this.oauth2Manager.checkAuthCode(authCode)) {
                    return OAuthASResponse.errorResponse((int)400).setError("invalid_request").setErrorDescription("invalid request").buildJSONMessage();
                }
                OpenUser user = this.oauth2Manager.getUserByAuthCode(authCode);
                if (user == null) {
                    throw OAuthProblemException.error((String)"Can not found user by code.");
                }
                long expiresIn = this.oauth2Manager.getExpireIn(apiConfig);
                TokenPair tokenPair = this.createNewToken(user);
                this.oauth2Manager.addAccessToken(tokenPair.getAccessToken(), tokenPair.getRefreshToken(), user, expiresIn);
                return this.buildAccessTokenResponse(tokenPair, expiresIn, user);
            }
            if (GrantType.REFRESH_TOKEN.toString().equals(grant_type)) {
                String refreshToken = oauthRequest.getParam("refresh_token");
                if (StringUtils.isEmpty((Object)refreshToken)) {
                    return OAuthASResponse.errorResponse((int)400).setError("expired_token").setErrorDescription("expired token").buildJSONMessage();
                }
                RefreshToken refreshTokenObj = this.oauth2Manager.getRefreshToken(refreshToken);
                if (refreshTokenObj == null) {
                    return OAuthASResponse.errorResponse((int)400).setError("invalid_token").setErrorDescription("invalid token").buildJSONMessage();
                }
                OpenUser user = refreshTokenObj.getOpenUser();
                long expiresIn = this.oauth2Manager.getExpireIn(apiConfig);
                TokenPair oldTokenPair = new TokenPair();
                oldTokenPair.setAccessToken(refreshTokenObj.getAccessToken());
                oldTokenPair.setRefreshToken(refreshToken);
                TokenPair newTokenPair = this.createRefreshToken(user, oldTokenPair);
                this.afterRefreshToken(oldTokenPair, newTokenPair, user, expiresIn);
                return this.buildAccessTokenResponse(newTokenPair, expiresIn, user);
            }
            return OAuthASResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("invalid grant").buildJSONMessage();
        }
        catch (OAuthProblemException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return OAuthASResponse.errorResponse((int)400).error(e).buildJSONMessage();
        }
    }

    protected void afterRefreshToken(TokenPair oldTokenPair, TokenPair newTokenPair, OpenUser user, long expiresIn) {
        this.oauth2Manager.addAccessToken(newTokenPair.getAccessToken(), newTokenPair.getRefreshToken(), user, expiresIn);
        this.oauth2Manager.removeAccessToken(oldTokenPair.getAccessToken());
        this.oauth2Manager.removeRefreshToken(oldTokenPair.getRefreshToken());
    }

    protected TokenPair createNewToken(OpenUser user) {
        return this.createDefaultTokenPair();
    }

    protected TokenPair createRefreshToken(OpenUser user, TokenPair oldTokenPair) {
        return this.createDefaultTokenPair();
    }

    private TokenPair createDefaultTokenPair() {
        TokenPair tokenPair = new TokenPair();
        try {
            String accessToken = this.oauthIssuer.accessToken();
            String refreshToken = this.oauthIssuer.refreshToken();
            tokenPair.setAccessToken(accessToken);
            tokenPair.setRefreshToken(refreshToken);
            return tokenPair;
        }
        catch (OAuthSystemException e) {
            throw new RuntimeException(e);
        }
    }

    private OAuthResponse buildAccessTokenResponse(TokenPair tokenPair, long expiresIn, OpenUser user) throws OAuthSystemException {
        OAuthASResponse.OAuthTokenResponseBuilder resp = OAuthASResponse.tokenResponse((int)200);
        Map<String, String> param = this.oauth2Manager.getParam(user);
        if (param != null) {
            Set<Map.Entry<String, String>> entrySet = param.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                resp.setParam(entry.getKey(), entry.getValue());
            }
        }
        return resp.setAccessToken(tokenPair.getAccessToken()).setRefreshToken(tokenPair.getRefreshToken()).setTokenType(TOKEN_TYPE).setExpiresIn(String.valueOf(expiresIn)).buildJSONMessage();
    }

    private boolean checkClientId(String clientId, ApiConfig apiConfig) {
        return apiConfig.getAppSecretManager().isValidAppKey(clientId);
    }

    private boolean checkClientSecret(String clientId, String clientSecret, ApiConfig apiConfig) {
        String secret = apiConfig.getAppSecretManager().getSecret(clientId);
        if (secret == null) {
            return false;
        }
        return secret.equals(clientSecret);
    }

    public Oauth2Manager getOauth2Manager() {
        return this.oauth2Manager;
    }

    @Override
    public void setOauth2Manager(Oauth2Manager oauth2Manager) {
        Assert.notNull((Object)oauth2Manager, (String)"oauth2Manager\u4e0d\u80fd\u4e3a\u7a7a");
        this.oauth2Manager = oauth2Manager;
    }
}

