/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.bean;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.bean.Api;
import com.gitee.easyopen.bean.ApiDefinition;
import com.gitee.easyopen.exception.DuplicateApiNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefinitionHolder {
    private static Map<String, ApiDefinition> apiDefinitionMap = new ConcurrentHashMap<String, ApiDefinition>(64);
    private static volatile String defaultVersion = null;

    public static void addApiDefinition(ApiDefinition apiDefinition) throws DuplicateApiNameException {
        String key = DefinitionHolder.getKey(apiDefinition);
        boolean hasApi = apiDefinitionMap.containsKey(key);
        if (hasApi) {
            throw new DuplicateApiNameException("\u91cd\u590d\u7533\u660e\u63a5\u53e3,name:" + apiDefinition.getName() + " ,version:" + apiDefinition.getVersion() + ",method:" + apiDefinition.getMethod().getName());
        }
        apiDefinitionMap.put(key, apiDefinition);
    }

    public static List<Api> listAllApi() {
        Collection<ApiDefinition> allApi = apiDefinitionMap.values();
        ArrayList<Api> ret = new ArrayList<Api>(allApi.size());
        for (ApiDefinition apiDefinition : allApi) {
            Api api = new Api();
            api.setName(apiDefinition.getName());
            api.setVersion(apiDefinition.getVersion());
            api.setDescription(apiDefinition.getDescription());
            api.setModuleName(apiDefinition.getModuleName());
            api.setOrderIndex(apiDefinition.getOrderIndex());
            ret.add(api);
        }
        return ret;
    }

    public static Map<String, ApiDefinition> getApiDefinitionMap() {
        return apiDefinitionMap;
    }

    public static ApiDefinition getByParam(ApiParam param) {
        String key = DefinitionHolder.getKey(param.fatchName(), param.fatchVersion());
        return apiDefinitionMap.get(key);
    }

    public static String getKey(ApiDefinition apiDefinition) {
        return DefinitionHolder.getKey(apiDefinition.getName(), apiDefinition.getVersion());
    }

    public static String getKey(String name, String version) {
        if (version == null) {
            version = DefinitionHolder.getDefaultVersion();
        }
        return name + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDefaultVersion() {
        if (defaultVersion != null) return defaultVersion;
        Class<DefinitionHolder> clazz = DefinitionHolder.class;
        synchronized (DefinitionHolder.class) {
            if (defaultVersion != null) return defaultVersion;
            defaultVersion = ApiContext.getApiConfig().getDefaultVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultVersion;
        }
    }

    public static void setApiInfo(Api api) {
        ApiDefinition apiDefinition = apiDefinitionMap.get(api.getName() + api.getVersion());
        if (apiDefinition != null) {
            apiDefinition.setDescription(api.getDescription());
            apiDefinition.setModuleName(api.getModuleName());
            apiDefinition.setOrderIndex(api.getOrderIndex());
        }
    }

    public static void clear() {
        apiDefinitionMap.clear();
        defaultVersion = null;
    }
}

