/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.config;

import com.gitee.easyopen.ManagerInitializer;
import com.gitee.easyopen.config.NettyClient;
import com.gitee.easyopen.config.StartupException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ConnectionListener
implements ChannelFutureListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile long DELAY_SECONDS = 5L;
    private static volatile boolean firstFail = true;
    private static AtomicInteger tryTimes = new AtomicInteger();
    private NettyClient nettyClient;

    public ConnectionListener(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
    }

    public void operationComplete(ChannelFuture channelFuture) throws Exception {
        if (channelFuture.isSuccess()) {
            tryTimes.set(0);
            firstFail = false;
            Channel channel = channelFuture.channel();
            EventLoop loop = channel.eventLoop();
            this.addShutdownListner(loop);
        } else {
            this.logger.info("Netty\u5ba2\u6237\u7aef\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u8fde({})", (Object)tryTimes.incrementAndGet());
            final EventLoop loop = channelFuture.channel().eventLoop();
            if (firstFail) {
                try {
                    this.fireLocalConfig(this.nettyClient.getInitializers());
                    firstFail = false;
                }
                catch (Exception e) {
                    channelFuture.channel().pipeline().fireExceptionCaught((Throwable)new StartupException(e));
                }
            }
            loop.schedule(new Runnable(){

                @Override
                public void run() {
                    ConnectionListener.this.nettyClient.reconnect((EventLoopGroup)loop);
                }
            }, DELAY_SECONDS, TimeUnit.SECONDS);
        }
    }

    public void fireLocalConfig(List<ManagerInitializer> initializers) {
        this.logger.info("Netty\u5ba2\u6237\u7aef\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668\uff0c\u5c1d\u8bd5\u52a0\u8f7d\u672c\u5730\u914d\u7f6e\u6587\u4ef6");
        for (ManagerInitializer managerInitializer : initializers) {
            managerInitializer.loadLocal();
        }
    }

    protected void addShutdownListner(final EventLoop loop) {
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                ConnectionListener.this.logger.info("\u6536\u5230\u8fdb\u7a0b\u4fe1\u53f7\u91cf\uff1a{}", (Object)signal.getName());
                Thread t = new Thread((Runnable)new ShutdownHook(loop), "NettyClient-ShutdownHook-Thread");
                Runtime.getRuntime().addShutdownHook(t);
                Runtime.getRuntime().exit(0);
            }
        };
        Signal.handle(new Signal(this.getOSSignalKill()), signalHandler);
    }

    private String getOSSignalKill() {
        return System.getProperties().getProperty("os.name").toLowerCase().startsWith("win") ? System.getProperty("term.sig", "INT") : System.getProperty("term.sig", "USR2");
    }

    class ShutdownHook
    implements Runnable {
        private EventLoop loop;

        public ShutdownHook(EventLoop loop) {
            this.loop = loop;
        }

        @Override
        public void run() {
            ConnectionListener.this.logger.info("\u8fdb\u7a0b\u9000\u51fa\uff0c\u5173\u95edNetty\u5ba2\u6237\u7aef...");
            this.loop.shutdownGracefully();
        }
    }
}

