/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.config;

import com.gitee.easyopen.ManagerInitializer;
import com.gitee.easyopen.config.ConfigClient;
import com.gitee.easyopen.config.ConnectionListener;
import com.gitee.easyopen.config.HeartBeatClientHandler;
import com.gitee.easyopen.config.MarshallingCodeCFactory;
import com.gitee.easyopen.config.NettyClientHandler;
import com.gitee.easyopen.config.NettyProcessor;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient {
    private static Logger logger = LoggerFactory.getLogger(NettyClient.class);
    private EventLoopGroup loop = new NioEventLoopGroup();
    private Map<String, NettyProcessor> processorMap;
    private List<ManagerInitializer> initializers;
    private String host;
    private int port;
    private String docUrl;

    public NettyClient(ConfigClient configClient, String host, int port) {
        this.processorMap = configClient.getProcessorMap();
        this.initializers = configClient.getInitializers();
        this.host = host;
        this.port = port;
        this.docUrl = configClient.getLocalServerPort();
    }

    public Bootstrap createBootstrap(Bootstrap bootstrap, EventLoopGroup eventLoop, boolean wait) {
        if (bootstrap != null) {
            logger.debug("\u8fde\u63a5Netty\u670d\u52a1\u5668\uff0cserverIp:{}, serverPort:{}", (Object)this.host, (Object)this.port);
            final NettyClientHandler handler = new NettyClientHandler(this);
            bootstrap.group(eventLoop);
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast("ping", (ChannelHandler)new IdleStateHandler(0L, 4L, 0L, TimeUnit.SECONDS));
                    pipeline.addLast("decoder", (ChannelHandler)MarshallingCodeCFactory.buildMarshallingDecoder());
                    pipeline.addLast("encoder", (ChannelHandler)MarshallingCodeCFactory.buildMarshallingEncoder());
                    pipeline.addLast("handler", (ChannelHandler)handler);
                    pipeline.addLast(new ChannelHandler[]{new HeartBeatClientHandler()});
                }
            });
            bootstrap.remoteAddress(this.host, this.port);
            bootstrap.connect().addListener((GenericFutureListener)new ConnectionListener(this));
        }
        return bootstrap;
    }

    public void run() {
        this.createBootstrap(new Bootstrap(), this.loop, true);
    }

    public void reconnect(EventLoopGroup loop) {
        this.createBootstrap(new Bootstrap(), loop, false);
    }

    public Map<String, NettyProcessor> getProcessorMap() {
        return this.processorMap;
    }

    public List<ManagerInitializer> getInitializers() {
        return this.initializers;
    }

    public EventLoopGroup getLoop() {
        return this.loop;
    }

    public String getLocalServerPort() {
        return this.docUrl;
    }
}

