/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.config;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.bean.Api;
import com.gitee.easyopen.bean.DefinitionHolder;
import com.gitee.easyopen.config.App;
import com.gitee.easyopen.config.ConfigMsg;
import com.gitee.easyopen.config.NettyClient;
import com.gitee.easyopen.config.NettyOpt;
import com.gitee.easyopen.config.NettyProcessor;
import com.gitee.easyopen.config.StartupException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends SimpleChannelInboundHandler<ConfigMsg> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private NettyClient nettyClient;
    private Map<String, NettyProcessor> processorMap;
    private String docUrl;

    public NettyClientHandler(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
        this.processorMap = nettyClient.getProcessorMap();
        this.docUrl = nettyClient.getLocalServerPort();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.info("\u8fde\u63a5\u914d\u7f6e\u4e2d\u5fc3\u6210\u529f");
        Channel channel = ctx.channel();
        this.registerServer(channel);
        this.syncAppApiInfi(channel);
        this.updateConfigFromServer(channel);
    }

    public void updateConfigFromServer(Channel channel) {
        this.logger.info("----\u5f00\u59cb\u540c\u6b65\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e----");
        try {
            this.downloadSecretConfig(channel);
            this.downloadPermissionConfig(channel);
            this.downloadLimitConfig(channel);
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u9519\u8bef", (Throwable)e);
        }
    }

    public void syncAppApiInfi(Channel channel) {
        this.logger.info("\u540c\u6b65\u672c\u5730API\u5230\u914d\u7f6e\u4e2d\u5fc3");
        ConfigMsg syncMsg = this.newConfigMsg(NettyOpt.SYNC_APP_API);
        List<Api> allApi = DefinitionHolder.listAllApi();
        syncMsg.setData(JSON.toJSONString(allApi));
        channel.writeAndFlush((Object)syncMsg);
    }

    public void registerServer(Channel channel) {
        ConfigMsg msg = this.newConfigMsg(NettyOpt.CLIENT_CONNECTED);
        ApiConfig apiConfig = ApiContext.getApiConfig();
        App app = new App();
        app.setApp(msg.getApp());
        app.setDocPassword(apiConfig.getDocPassword());
        app.setDocStatus(apiConfig.getShowDoc() != false ? (byte)1 : 0);
        app.setDocUrl(this.docUrl);
        msg.setData(JSON.toJSONString((Object)app));
        channel.writeAndFlush((Object)msg);
    }

    public ConfigMsg newConfigMsg(NettyOpt nettyOpt) {
        ConfigMsg msg = new ConfigMsg();
        msg.setApp(ApiContext.getAppName());
        msg.setCode(nettyOpt.getCode());
        return msg;
    }

    public void downloadSecretConfig(Channel channel) {
        this.logger.info("\u4e0b\u8f7d\u79d8\u94a5\u914d\u7f6e");
        ConfigMsg msg = this.newConfigMsg(NettyOpt.DOWNLOAD_SECRET_CONFIG);
        channel.writeAndFlush((Object)msg);
    }

    public void downloadPermissionConfig(Channel channel) {
        this.logger.info("\u4e0b\u8f7d\u6743\u9650\u914d\u7f6e");
        ConfigMsg msg = this.newConfigMsg(NettyOpt.DOWNLOAD_PERMISSION_CONFIG);
        channel.writeAndFlush((Object)msg);
    }

    public void downloadLimitConfig(Channel channel) {
        this.logger.info("\u4e0b\u8f7d\u9650\u6d41\u914d\u7f6e");
        ConfigMsg msg = this.newConfigMsg(NettyOpt.DOWNLOAD_LIMIT_CONFIG);
        channel.writeAndFlush((Object)msg);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ConfigMsg configMsg) throws Exception {
        String code = configMsg.getCode();
        NettyProcessor processor = this.processorMap.get(code);
        if (processor == null) {
            throw new RuntimeException("\u9519\u8bef\u7684code:" + code);
        }
        processor.process(ctx.channel(), configMsg.getData());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        final EventLoop eventLoop = ctx.channel().eventLoop();
        if (eventLoop.isShuttingDown()) {
            super.channelInactive(ctx);
            return;
        }
        this.logger.info("\u5df2\u65ad\u5f00\u4e0e\u670d\u52a1\u7aef\u7684\u94fe\u63a5\uff0c\u5c1d\u8bd5\u91cd\u8fde...");
        eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                NettyClientHandler.this.nettyClient.reconnect((EventLoopGroup)eventLoop);
            }
        }, 5L, TimeUnit.SECONDS);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof StartupException) {
            this.logger.error("Netty\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25:", cause);
            ctx.channel().close();
            System.exit(0);
        } else {
            this.logger.error("Netty\u9519\u8bef", cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

