/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.config.processor;

import com.gitee.easyopen.config.ConfigClient;
import com.gitee.easyopen.config.CountDownLatchManager;
import com.gitee.easyopen.config.NettyOpt;
import com.gitee.easyopen.config.NettyProcessor;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNettyProcessor
implements NettyProcessor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile int lockObjectCount = 0;
    protected ConfigClient configClient;
    protected NettyOpt nettyOpt;

    public AbstractNettyProcessor(ConfigClient configClient, NettyOpt nettyOpt) {
        this.configClient = configClient;
        this.nettyOpt = nettyOpt;
        if (this.hasLock()) {
            ++lockObjectCount;
        }
    }

    protected abstract void doProcess(Channel var1, String var2);

    protected boolean hasLock() {
        return true;
    }

    @Override
    public synchronized void process(Channel channel, String data) {
        try {
            this.doProcess(channel, data);
        }
        finally {
            if (this.hasLock()) {
                CountDownLatchManager.countDown();
            }
        }
    }

    public String getCode() {
        return this.nettyOpt.getCode();
    }

    public static int getLockObjectCount() {
        return lockObjectCount;
    }
}

