/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.doc;

import com.gitee.easyopen.bean.Api;
import com.gitee.easyopen.doc.ApiDocBuilder;
import com.gitee.easyopen.doc.ApiDocHolder;
import com.gitee.easyopen.doc.annotation.ApiDocMethod;
import com.gitee.easyopen.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public abstract class AbstractApiDocCreator<ServiceAnnotation extends Annotation, MethodAnnotation extends Annotation> {
    private String defaultVersion;
    private ApplicationContext applicationContext;

    public AbstractApiDocCreator(String defaultVersion, ApplicationContext applicationContext) {
        if (defaultVersion == null) {
            defaultVersion = "";
        }
        this.defaultVersion = defaultVersion;
        this.applicationContext = applicationContext;
    }

    protected abstract Class<ServiceAnnotation> getServiceAnnotationClass();

    protected abstract Class<MethodAnnotation> getMethodAnnotationClass();

    protected abstract Api getApi(MethodAnnotation var1);

    public void create() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext\u4e0d\u80fd\u4e3a\u7a7a");
        String[] beans = ReflectionUtil.findBeanNamesByAnnotationClass(this.applicationContext, this.getServiceAnnotationClass());
        ApiDocBuilder apiDocBuilder = ApiDocHolder.createBuilder();
        for (String beanName : beans) {
            Method[] methods;
            Object handler = this.applicationContext.getBean(beanName);
            Class<?> beanClass = handler.getClass();
            for (Method method : methods = beanClass.getDeclaredMethods()) {
                Annotation methodAnnotation = AnnotationUtils.findAnnotation((Method)method, this.getMethodAnnotationClass());
                ApiDocMethod apiDocMethod = (ApiDocMethod)AnnotationUtils.findAnnotation((Method)method, ApiDocMethod.class);
                if (method.isSynthetic() || methodAnnotation == null || apiDocMethod == null) continue;
                Api api = this.getApi(methodAnnotation);
                if (api.getVersion() == null || "".equals(api.getVersion().trim())) {
                    api.setVersion(this.defaultVersion);
                }
                apiDocBuilder.addDocItem(api, handler, method);
            }
        }
    }
}

