/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.doc;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiResult;
import com.gitee.easyopen.Result;
import com.gitee.easyopen.bean.Api;
import com.gitee.easyopen.bean.DefinitionHolder;
import com.gitee.easyopen.doc.ApiDocFieldDefinition;
import com.gitee.easyopen.doc.ApiDocItem;
import com.gitee.easyopen.doc.ApiDocReturnDefinition;
import com.gitee.easyopen.doc.ApiModule;
import com.gitee.easyopen.doc.DataType;
import com.gitee.easyopen.doc.IEnum;
import com.gitee.easyopen.doc.NoResultWrapper;
import com.gitee.easyopen.doc.Orderable;
import com.gitee.easyopen.doc.annotation.ApiDoc;
import com.gitee.easyopen.doc.annotation.ApiDocBean;
import com.gitee.easyopen.doc.annotation.ApiDocField;
import com.gitee.easyopen.doc.annotation.ApiDocMethod;
import com.gitee.easyopen.doc.annotation.ApiDocReturn;
import com.gitee.easyopen.doc.annotation.ApiDocRootData;
import com.gitee.easyopen.exception.ApiException;
import com.gitee.easyopen.register.SingleParameterContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ApiDocBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ApiDocBuilder.class);
    private static String PACKAGE_PREFIX = "java.";
    private Map<String, ApiModule> apiModuleMap = new ConcurrentHashMap<String, ApiModule>(64);
    private static Map<String, ApiDoc> apiDocCache = new ConcurrentHashMap<String, ApiDoc>(64);
    private static Map<String, ApiDocItem> apiDocItemCache = new ConcurrentHashMap<String, ApiDocItem>(64);
    private Class<?> lastClass;
    private int loopCount;
    private volatile List<ApiModule> allApiModules;

    public ApiDocItem getApiDocItem(String name, String version) {
        return apiDocItemCache.get(name + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection<ApiModule> getApiModules() {
        if (this.allApiModules != null) return this.allApiModules;
        Class<ApiDocBuilder> clazz = ApiDocBuilder.class;
        synchronized (ApiDocBuilder.class) {
            if (this.allApiModules != null) return this.allApiModules;
            CopyOnWriteArrayList<ApiModule> apiModules = new CopyOnWriteArrayList<ApiModule>(this.apiModuleMap.values());
            this.sort(apiModules);
            for (ApiModule apiModule : apiModules) {
                this.sort(apiModule.getModuleItems());
            }
            this.allApiModules = apiModules;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.allApiModules;
        }
    }

    protected <T extends Orderable> void sort(List<T> list) {
        ArrayList<Orderable> listHasOrder = new ArrayList<Orderable>();
        ArrayList<Orderable> listNoOrder = new ArrayList<Orderable>();
        int max = Integer.MAX_VALUE;
        for (Orderable orderable : list) {
            if (orderable.getOrder() == max) {
                listNoOrder.add(orderable);
                continue;
            }
            listHasOrder.add(orderable);
        }
        Collections.sort(listHasOrder, new Comparator<Orderable>(){

            @Override
            public int compare(Orderable o1, Orderable o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        Collections.sort(listNoOrder, new Comparator<Orderable>(){

            @Override
            public int compare(Orderable o1, Orderable o2) {
                return o1.getOrderName().compareTo(o2.getOrderName());
            }
        });
        list.clear();
        list.addAll(listHasOrder);
        list.addAll(listNoOrder);
    }

    public synchronized void addDocItem(Api api, Object handler, Method method) {
        ApiDocMethod apiDocMethod = (ApiDocMethod)AnnotationUtils.findAnnotation((Method)method, ApiDocMethod.class);
        if (apiDocMethod == null) {
            return;
        }
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        String serviceName = handlerClass.getSimpleName();
        int order = Integer.MAX_VALUE;
        ApiDoc apiDoc = this.getApiDoc(handler);
        if (apiDoc != null) {
            serviceName = apiDoc.value();
            order = apiDoc.order();
        }
        api.setModuleName(serviceName);
        api.setDescription(apiDocMethod.description());
        api.setOrderIndex(order);
        DefinitionHolder.setApiInfo(api);
        ApiModule apiModule = this.getApiModule(serviceName, order);
        ApiDocItem apiDocItem = this.buildDocItem(api, apiDocMethod, method);
        apiModule.getModuleItems().add(apiDocItem);
        this.putCache(apiDocItem);
    }

    protected void putCache(ApiDocItem apiDocItem) {
        apiDocItemCache.put(apiDocItem.getNameVersion(), apiDocItem);
    }

    protected ApiDoc getApiDoc(Object handler) {
        String className = handler.getClass().getName();
        ApiDoc apiDoc = apiDocCache.get(className);
        if (apiDoc == null && (apiDoc = (ApiDoc)AnnotationUtils.findAnnotation(handler.getClass(), ApiDoc.class)) != null) {
            apiDocCache.put(className, apiDoc);
        }
        return apiDoc;
    }

    protected ApiModule getApiModule(String serviceName, int order) {
        ApiModule apiModule = this.apiModuleMap.get(serviceName);
        if (apiModule == null) {
            apiModule = new ApiModule(serviceName, order);
            this.apiModuleMap.put(serviceName, apiModule);
        }
        return apiModule;
    }

    protected ApiDocItem buildDocItem(Api api, ApiDocMethod apiDocMethod, Method method) {
        List<ApiDocFieldDefinition> wrapper;
        ApiDocItem docItem = new ApiDocItem();
        docItem.setName(api.getName());
        docItem.setVersion(api.getVersion());
        docItem.setDescription(apiDocMethod.description());
        docItem.setRemark(apiDocMethod.remark());
        docItem.setOrder(apiDocMethod.order());
        List<ApiDocFieldDefinition> paramDefinitions = this.buildParamApiDocFieldDefinitions(apiDocMethod, method, api);
        List<ApiDocFieldDefinition> resultDefinitions = this.buildResultApiDocFieldDefinitions(apiDocMethod, method);
        ApiDocReturnDefinition apiDocReturnDefinition = this.buildApiDocReturnDefinition(method);
        Class<? extends Result> wrapperClass = this.getWrapperClass(apiDocMethod);
        if (wrapperClass == ApiResult.class) {
            wrapper = resultDefinitions;
        } else if (wrapperClass == NoResultWrapper.class) {
            docItem.setCustomWrapper(true);
            wrapper = resultDefinitions;
        } else {
            docItem.setCustomWrapper(true);
            wrapper = this.buildApiDocFieldDefinitionsByClass(wrapperClass);
            boolean hasRootAnno = false;
            for (ApiDocFieldDefinition wrapperDefinition : wrapper) {
                if (!wrapperDefinition.isRootData()) continue;
                hasRootAnno = true;
                wrapperDefinition.setElements(resultDefinitions);
                break;
            }
            if (!hasRootAnno) {
                logger.error(wrapperClass.getName() + "\u6ca1\u6709\u8bbe\u7f6e@ApiDocRootData\u6ce8\u89e3");
            }
        }
        docItem.setParamDefinitions(paramDefinitions);
        docItem.setResultDefinitions(wrapper);
        docItem.setApiDocReturnDefinition(apiDocReturnDefinition);
        HashMap<String, Object> paramRootData = new HashMap<String, Object>();
        for (ApiDocFieldDefinition paramDefinition : paramDefinitions) {
            this.fillDefinitionData(paramRootData, paramDefinition);
        }
        docItem.setParamData(paramRootData);
        if (apiDocMethod.elementClass() != Object.class) {
            ArrayList rootList = new ArrayList();
            try {
                Object o = apiDocMethod.elementClass().newInstance();
                rootList.add(o);
                Result result = wrapperClass.newInstance();
                result.setData(rootList);
                docItem.setResultData(result);
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
            }
        } else {
            HashMap<String, Object> resultRootData = new HashMap<String, Object>();
            for (ApiDocFieldDefinition resultDefinition : resultDefinitions) {
                this.fillDefinitionData(resultRootData, resultDefinition);
            }
            try {
                if (wrapperClass == NoResultWrapper.class) {
                    docItem.setResultData(resultRootData);
                } else {
                    Result result = wrapperClass.newInstance();
                    result.setData(resultRootData);
                    docItem.setResultData(result);
                }
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
            }
        }
        return docItem;
    }

    protected void fillDefinitionData(Map<String, Object> data, ApiDocFieldDefinition definition) {
        Cloneable value;
        String name = definition.getName();
        List<ApiDocFieldDefinition> elements = definition.getElements();
        boolean isArray = definition.getDataType().equalsIgnoreCase(DataType.ARRAY.name());
        if (elements.size() > 0) {
            if (isArray) {
                ArrayList<HashMap<String, Object>> elList = new ArrayList<HashMap<String, Object>>(elements.size());
                HashMap<String, Object> elData = new HashMap<String, Object>();
                for (ApiDocFieldDefinition element : elements) {
                    this.fillDefinitionData(elData, element);
                }
                elList.add(elData);
                value = elList;
            } else {
                HashMap<String, Object> val = new HashMap<String, Object>();
                for (ApiDocFieldDefinition element : elements) {
                    this.fillDefinitionData(val, element);
                }
                value = val;
            }
        } else {
            value = isArray ? Collections.emptyList() : definition.getExample();
        }
        data.put(name, value);
    }

    protected ApiDocReturnDefinition buildApiDocReturnDefinition(Method method) {
        ApiDocReturn apiDocReturn = (ApiDocReturn)AnnotationUtils.findAnnotation((Method)method, ApiDocReturn.class);
        if (apiDocReturn == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        ApiDocReturnDefinition apiDocReturnDefinition = new ApiDocReturnDefinition();
        apiDocReturnDefinition.setDescription(apiDocReturn.description());
        apiDocReturnDefinition.setDataType(returnType.getSimpleName().toLowerCase());
        apiDocReturnDefinition.setExample(apiDocReturn.example());
        return apiDocReturnDefinition;
    }

    protected Class<? extends Result> getWrapperClass(ApiDocMethod apiDocMethod) {
        Class<? extends Result> methodWrapperClass;
        Class<? extends Result> wrapperClass = null;
        ApiConfig apiConfig = ApiContext.getApiConfig();
        if (apiConfig != null) {
            wrapperClass = apiConfig.getWrapperClass();
        }
        if (wrapperClass == null) {
            wrapperClass = ApiResult.class;
        }
        if ((methodWrapperClass = apiDocMethod.wrapperClass()) != Result.class) {
            wrapperClass = methodWrapperClass;
        }
        return wrapperClass;
    }

    protected List<ApiDocFieldDefinition> buildParamApiDocFieldDefinitions(ApiDocMethod apiDocMethod, Method method, Api api) {
        List<ApiDocFieldDefinition> paramDefinitions = Collections.emptyList();
        Object[] params = apiDocMethod.params();
        Class<?> paramClass = apiDocMethod.paramClass();
        paramDefinitions = !ArrayUtils.isEmpty((Object[])params) ? this.buildApiDocFieldDefinitionsByApiDocFields((ApiDocField[])params) : (paramClass != Object.class ? this.buildApiDocFieldDefinitionsByClass(paramClass) : this.buildParamDefinitions(method, api));
        return paramDefinitions;
    }

    protected List<ApiDocFieldDefinition> buildResultApiDocFieldDefinitions(ApiDocMethod apiDocMethod, Method method) {
        List<ApiDocFieldDefinition> resultDefinitions = Collections.emptyList();
        Class<?> elClass = apiDocMethod.elementClass();
        if (elClass != Object.class) {
            return this.buildApiDocFieldDefinitionsByType(elClass, true);
        }
        Object[] results = apiDocMethod.results();
        Class<?> resultClass = apiDocMethod.resultClass();
        resultDefinitions = !ArrayUtils.isEmpty((Object[])results) ? this.buildApiDocFieldDefinitionsByApiDocFields((ApiDocField[])results) : (resultClass != Object.class ? this.buildApiDocFieldDefinitionsByClass(resultClass) : this.buildResultDefinitions(method));
        return resultDefinitions;
    }

    protected List<ApiDocFieldDefinition> buildApiDocFieldDefinitionsByClass(Class<?> paramClass) {
        Object[] fields;
        ApiDocBean bean = (ApiDocBean)AnnotationUtils.findAnnotation(paramClass, ApiDocBean.class);
        if (bean != null && !ArrayUtils.isEmpty((Object[])(fields = bean.fields()))) {
            return this.buildApiDocFieldDefinitionsByApiDocFields((ApiDocField[])fields);
        }
        return this.buildApiDocFieldDefinitionsByType(paramClass, true);
    }

    protected List<ApiDocFieldDefinition> buildApiDocFieldDefinitionsByApiDocFields(ApiDocField[] params) {
        ArrayList<ApiDocFieldDefinition> paramDefinitions = new ArrayList<ApiDocFieldDefinition>();
        for (ApiDocField apiDocField : params) {
            if (apiDocField.beanClass() != Void.class) {
                paramDefinitions.add(this.buildApiDocFieldDefinitionByClass(apiDocField, apiDocField.beanClass(), null));
                continue;
            }
            paramDefinitions.add(this.buildApiDocFieldDefinition(apiDocField, null));
        }
        return paramDefinitions;
    }

    protected List<ApiDocFieldDefinition> buildParamDefinitions(Method method, Api api) {
        SingleParameterContext.SingleParameterContextValue value = SingleParameterContext.get(api.getName(), api.getVersion());
        if (value != null) {
            return this.buildApiDocFieldDefinitionsByType(value.getWrapClass(), true);
        }
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return Collections.emptyList();
        }
        Class<?> paramClass = types[0];
        return this.buildApiDocFieldDefinitionsByType(paramClass, true);
    }

    protected List<ApiDocFieldDefinition> buildResultDefinitions(Method method) {
        Class<?> type = method.getReturnType();
        if (type == Void.class) {
            return Collections.emptyList();
        }
        return this.buildApiDocFieldDefinitionsByType(type, true);
    }

    protected List<ApiDocFieldDefinition> buildApiDocFieldDefinitionsByType(Class<?> clazz, final boolean root) {
        if (clazz.isInterface()) {
            return Collections.emptyList();
        }
        this.addCycle(clazz);
        ArrayList<String> fieldNameList = new ArrayList<String>();
        final ArrayList<ApiDocFieldDefinition> docDefinition = new ArrayList<ApiDocFieldDefinition>();
        ApiDocBean apiDocBean = (ApiDocBean)AnnotationUtils.findAnnotation(clazz, ApiDocBean.class);
        if (apiDocBean != null) {
            ApiDocField[] fields;
            for (ApiDocField apiDocField : fields = apiDocBean.fields()) {
                docDefinition.add(this.buildApiDocFieldDefinition(apiDocField, null));
                fieldNameList.add(apiDocField.name());
            }
        }
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ApiDocField docField = (ApiDocField)AnnotationUtils.findAnnotation((AnnotatedElement)field, ApiDocField.class);
                if (docField != null) {
                    if (root) {
                        ApiDocBuilder.this.resetCycle();
                    }
                    ApiDocFieldDefinition fieldDefinition = ApiDocBuilder.this.buildApiDocFieldDefinition(docField, field);
                    Class<?> beanClass = docField.beanClass();
                    Class<?> targetClass = field.getType();
                    if (beanClass != Void.class) {
                        fieldDefinition = ApiDocBuilder.this.buildApiDocFieldDefinitionByClass(docField, beanClass, field);
                    } else if (!ApiDocBuilder.isJavaType(targetClass)) {
                        fieldDefinition = ApiDocBuilder.this.buildApiDocFieldDefinitionByClass(docField, targetClass, field);
                    }
                    ApiDocRootData rootData = (ApiDocRootData)AnnotationUtils.findAnnotation((AnnotatedElement)field, ApiDocRootData.class);
                    if (rootData != null) {
                        fieldDefinition.setRootData(true);
                    }
                    docDefinition.add(fieldDefinition);
                }
            }
        });
        return docDefinition;
    }

    private void addCycle(Class<?> clazz) {
        this.loopCount = this.lastClass == clazz ? ++this.loopCount : 0;
        this.lastClass = clazz;
    }

    private void resetCycle() {
        this.loopCount = 0;
    }

    protected static boolean isJavaType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return true;
        }
        Package pkg = type.getPackage();
        if (pkg == null) {
            return false;
        }
        return pkg.getName().startsWith(PACKAGE_PREFIX);
    }

    protected ApiDocFieldDefinition buildApiDocFieldDefinitionByClass(ApiDocField docField, Class<?> clazz, Field field) {
        String name = docField.name();
        String type = docField.dataType() != DataType.UNKNOW ? docField.dataType().getValue() : DataType.OBJECT.getValue();
        String description = docField.description();
        String enumDescription = ApiDocBuilder.getEnumDescription(docField.enumClass());
        if (StringUtils.isNotBlank((String)enumDescription)) {
            enumDescription = "<br/>" + enumDescription;
        }
        description = description + enumDescription;
        boolean required = docField.required();
        String example = docField.example();
        if (clazz == MultipartFile.class) {
            type = DataType.FILE.getValue();
        }
        if (field != null && StringUtils.isBlank((String)name)) {
            name = field.getName();
        }
        ApiDocFieldDefinition fieldDefinition = new ApiDocFieldDefinition();
        fieldDefinition.setName(name);
        fieldDefinition.setDataType(type);
        fieldDefinition.setRequired(String.valueOf(required));
        fieldDefinition.setExample(example);
        fieldDefinition.setDescription(description);
        fieldDefinition.setMaxLength(this.buildMaxLength(docField, field));
        List<ApiDocFieldDefinition> elementsDefinition = this.buildApiDocFieldDefinitionsByType(clazz, false);
        fieldDefinition.setElements(elementsDefinition);
        return fieldDefinition;
    }

    private String buildMaxLength(ApiDocField docField, Field field) {
        String maxLength = docField.maxLength();
        if (StringUtils.isNotBlank((String)maxLength)) {
            return maxLength;
        }
        if (field != null) {
            Length length = field.getAnnotation(Length.class);
            if (length != null) {
                return String.valueOf(length.max());
            }
            Class<?> type = field.getType();
            if (type == Boolean.class || type == Boolean.TYPE) {
                return "2";
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return "4";
            }
            if (type == Short.class || type == Short.TYPE || type == Character.class || type == Character.TYPE) {
                return "6";
            }
            if (type == Integer.class || type == Integer.TYPE || type == Float.class || type == Float.TYPE || type == BigDecimal.class || type == AtomicInteger.class) {
                return "11";
            }
            if (type == Long.class || type == Long.TYPE || type == AtomicLong.class) {
                return "20";
            }
            if (type == BigInteger.class) {
                return "32";
            }
        }
        return maxLength;
    }

    protected ApiDocFieldDefinition buildApiDocFieldDefinition(ApiDocField docField, Field field) {
        DataType dataType;
        String type = ApiDocBuilder.getFieldType(field);
        String fieldName = docField.name();
        if (StringUtils.isBlank((String)fieldName)) {
            fieldName = Optional.ofNullable(field).map(Field::getName).orElse("");
        }
        if ((dataType = docField.dataType()) != DataType.UNKNOW) {
            type = dataType.getValue();
        }
        String description = docField.description();
        String enumDescription = ApiDocBuilder.getEnumDescription(docField.enumClass());
        if (StringUtils.isNotBlank((String)enumDescription)) {
            enumDescription = "<br/>" + enumDescription;
        }
        description = description + enumDescription;
        boolean required = docField.required();
        String example = docField.example();
        ApiDocFieldDefinition fieldDefinition = new ApiDocFieldDefinition();
        fieldDefinition.setName(fieldName);
        fieldDefinition.setDataType(type);
        fieldDefinition.setRequired(String.valueOf(required));
        fieldDefinition.setExample(example);
        fieldDefinition.setDescription(description);
        fieldDefinition.setMaxLength(this.buildMaxLength(docField, field));
        List<ApiDocFieldDefinition> elementsDefinition = this.loopCount < 1 ? this.buildElementListDefinition(docField) : Collections.emptyList();
        fieldDefinition.setElements(elementsDefinition);
        fieldDefinition.setElementClass(docField.elementClass());
        if (elementsDefinition.size() > 0) {
            fieldDefinition.setDataType(DataType.ARRAY.getValue());
        }
        return fieldDefinition;
    }

    protected static String getEnumDescription(Class<?> enmuClass) {
        if (enmuClass == Void.class) {
            return "";
        }
        Class<?>[] interfaces = enmuClass.getInterfaces();
        boolean hasIEnum = false;
        for (Class<?> interfacesForClass : interfaces) {
            if (interfacesForClass != IEnum.class) continue;
            hasIEnum = true;
            break;
        }
        if (!hasIEnum) {
            throw new ApiException(enmuClass.getName() + "\u5fc5\u987b\u5b9e\u73b0" + IEnum.class.getName() + "\u63a5\u53e3");
        }
        IEnum[] enums = (IEnum[])enmuClass.getEnumConstants();
        if (enums == null || enums.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (IEnum anEnum : enums) {
            sb.append(", ").append(anEnum.getCode()).append("\uff1a").append(anEnum.getDescription());
            if (++i % 5 != 0) continue;
            sb.append("<br/>");
        }
        return sb.substring(1);
    }

    protected static String getFieldType(Field field) {
        if (field == null) {
            return DataType.STRING.getValue();
        }
        Class<?> type = field.getType();
        if (type == List.class || type == Collection.class || type == Set.class || type.isArray()) {
            return DataType.ARRAY.getValue();
        }
        if (type == Date.class) {
            return DataType.DATE.getValue();
        }
        if (type == Timestamp.class) {
            return DataType.DATETIME.getValue();
        }
        return field.getType().getSimpleName().toLowerCase();
    }

    protected List<ApiDocFieldDefinition> buildElementListDefinition(ApiDocField docField) {
        Class<?> elClass = docField.elementClass();
        if (elClass != Void.class) {
            return this.buildApiDocFieldDefinitionsByType(elClass, false);
        }
        return Collections.emptyList();
    }
}

