/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.doc;

import com.gitee.easyopen.doc.ApiDocItem;
import com.gitee.easyopen.doc.ApiModule;
import com.gitee.easyopen.doc.DocFileCreator;
import com.gitee.easyopen.util.VelocityUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class MarkdownDocCreator
implements DocFileCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MarkdownDocCreator.class);
    private static final String MARKDWON_SUFFIX = ".md";
    private static final String SIDEBAR_FILENAME = "_sidebar.md";
    private static final String API_FOLDER = "api/";
    private static final String MODULE_TPL = "\r\n\r\n* %s\r\n\r\n";
    private static final String FILE_TPL = "  * [%s](api/%s.md)\r\n";
    private static final String MARKDOWN_TEMPLATE_CLASSPATH = "/easyopen_template/markdownDoc.md";
    private String docsDir;
    private String apiDir;
    private String template = "/easyopen_template/markdownDoc.md";

    public MarkdownDocCreator(String dir) {
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        this.docsDir = dir + "docs/";
        this.apiDir = this.docsDir + API_FOLDER;
    }

    public MarkdownDocCreator(String dir, String template) {
        this(dir);
        this.template = template;
    }

    @Override
    public void createMarkdownDoc(Collection<ApiModule> apiModules) throws IOException {
        LOG.info("\u751f\u6210markdown\u6587\u6863\u6587\u4ef6\uff0c\u4fdd\u5b58\u8def\u5f84\uff1a{}", (Object)this.apiDir);
        this.createSidebar(apiModules);
        for (ApiModule apiModule : apiModules) {
            List<ApiDocItem> moduleItems = apiModule.getModuleItems();
            for (ApiDocItem item : moduleItems) {
                this.createDocFile(item);
            }
        }
    }

    protected void createSidebar(Collection<ApiModule> apiModules) throws IOException {
        StringBuilder sidebarContent = new StringBuilder();
        for (ApiModule apiModule : apiModules) {
            sidebarContent.append(String.format(MODULE_TPL, apiModule.getName()));
            List<ApiDocItem> moduleItems = apiModule.getModuleItems();
            for (ApiDocItem item : moduleItems) {
                sidebarContent.append(String.format(FILE_TPL, item.getDescription(), item.getNameVersion()));
            }
        }
        String siderbarFilePath = this.docsDir + SIDEBAR_FILENAME;
        FileUtils.write((File)new File(siderbarFilePath), (CharSequence)sidebarContent.toString(), (String)"UTF-8");
    }

    protected void createDocFile(ApiDocItem item) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("docItem", (Object)item);
        ClassPathResource resource = new ClassPathResource(this.template);
        String fileContent = VelocityUtil.generateToString(context, resource.getInputStream());
        String filepath = this.apiDir + item.getNameVersion() + MARKDWON_SUFFIX;
        FileUtils.write((File)new File(filepath), (CharSequence)fileContent, (String)"UTF-8");
    }

    public void setDocsDir(String docsDir) {
        this.docsDir = docsDir;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setApiDir(String apiDir) {
        this.apiDir = apiDir;
    }
}

