/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.doc;

import com.gitee.easyopen.doc.ApiDocFieldDefinition;
import com.gitee.easyopen.doc.DataType;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ParamHtmlBuilder {
    private static final String START_TD = "<td>";
    private static final String END_TD = "</td>";
    private static final String START_TR = "<tr>";
    private static final String END_TR = "</tr>";
    private static final String TRUE = "true";

    public String buildHtml(ApiDocFieldDefinition definition, String nameVersion) {
        StringBuilder html = new StringBuilder();
        html.append(START_TR).append(this.wrapTD(definition.getName())).append("<td class=\"param-type\">" + definition.getDataType() + END_TD).append(this.wrapTD(this.getRequireHtml(definition))).append(this.wrapTD(definition.getMaxLength())).append(this.wrapArrayTD(this.buildExample(definition, nameVersion, null), definition)).append(this.wrapTD(definition.getDescription()));
        html.append(END_TR);
        return html.toString();
    }

    private String wrapTD(String content) {
        return START_TD + content + END_TD;
    }

    private String wrapArrayTD(String content, ApiDocFieldDefinition definition) {
        return START_TD + this.getAddBtn(definition) + content + END_TD;
    }

    protected String buildExample(ApiDocFieldDefinition definition, String nameVersion, ApiDocFieldDefinition parentDefinition) {
        StringBuilder html = new StringBuilder();
        if (CollectionUtils.isNotEmpty(definition.getElements())) {
            html.append("<table parentname=\"" + definition.getName() + "\">").append(START_TR).append("<th>\u540d\u79f0</th>").append("<th>\u7c7b\u578b</th>").append("<th>\u662f\u5426\u5fc5\u987b</th>").append("<th>\u6700\u5927\u957f\u5ea6</th>").append("<th>\u793a\u4f8b\u503c</th>").append("<th>\u63cf\u8ff0</th>").append(END_TR);
            List<ApiDocFieldDefinition> els = definition.getElements();
            for (ApiDocFieldDefinition apiDocFieldDefinition : els) {
                html.append(START_TR).append(this.wrapTD(apiDocFieldDefinition.getName())).append("<td class=\"param-type\">" + apiDocFieldDefinition.getDataType() + END_TD).append(this.wrapTD(this.getRequireHtml(apiDocFieldDefinition))).append(this.wrapTD(apiDocFieldDefinition.getMaxLength())).append(this.wrapTD(this.buildExample(apiDocFieldDefinition, nameVersion, definition))).append(this.wrapTD(apiDocFieldDefinition.getDescription())).append(END_TR);
            }
            html.append("</table>");
        } else {
            html.append(this.buildExampleValue(definition, nameVersion, parentDefinition));
        }
        return html.toString();
    }

    private String getRequireHtml(ApiDocFieldDefinition definition) {
        if (TRUE.equals(definition.getRequired())) {
            return "<strong>\u662f</strong>";
        }
        return "\u5426";
    }

    protected String buildExampleValue(ApiDocFieldDefinition definition, String nameVersion, ApiDocFieldDefinition parentDefinition) {
        String parentname = parentDefinition == null ? "" : parentDefinition.getName();
        String type = "text";
        if (definition.getDataType().equals(DataType.FILE.getValue()) || definition.getElementClass() == MultipartFile.class) {
            type = "file";
        }
        String id = nameVersion + "_" + definition.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("<input id=\"").append(id).append("\" class=\"param-input\" type=\"").append(type).append("\" name=\"").append(definition.getName()).append("\" value=\"").append(definition.getExample()).append("\" ").append(this.getArrAttr(definition)).append(this.getDateEvent(definition)).append(" parentname=\"").append(parentname).append("\" ").append(" />");
        return sb.toString();
    }

    protected String getArrAttr(ApiDocFieldDefinition definition) {
        if (definition.getDataType().equals(DataType.ARRAY.getValue())) {
            return " arrinput=\"true\" ";
        }
        return "";
    }

    protected String getDateEvent(ApiDocFieldDefinition definition) {
        if (definition.getDataType().equals(DataType.DATE.getValue())) {
            return " onClick=\"WdatePicker({el:this,dateFmt:'yyyy-MM-dd'})\"";
        }
        if (definition.getDataType().equals(DataType.DATETIME.getValue())) {
            return " onClick=\"WdatePicker({el:this,dateFmt:'yyyy-MM-dd HH:mm:ss'})\"";
        }
        return "";
    }

    protected String getAddBtn(ApiDocFieldDefinition definition) {
        if (definition.getDataType().equals(DataType.ARRAY.getValue())) {
            return " <button type=\"button\" title=\"\u6dfb\u52a0\u4e00\u884c\" class=\"add-array-btn\">+</button> <button type=\"button\" title=\"\u5220\u9664\u4e00\u884c\" class=\"del-array-btn\">-</button>";
        }
        return "";
    }
}

