/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.jwt.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.jwt.JwtService;
import com.gitee.easyopen.message.Errors;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtServiceImpl
implements JwtService {
    private static Logger logger = LoggerFactory.getLogger(JwtServiceImpl.class);
    private static Map<String, Object> headerClaims = new HashMap<String, Object>();

    @Override
    public String createJWT(Map<String, String> data) {
        JWTCreator.Builder builder = JWT.create().withHeader(headerClaims);
        Set<Map.Entry<String, String>> entrySet = data.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            builder.withClaim(entry.getKey(), entry.getValue());
        }
        ApiConfig apiConfig = ApiContext.getApiConfig();
        Calendar expiredTime = Calendar.getInstance();
        expiredTime.add(13, apiConfig.getJwtExpireIn());
        try {
            return builder.withExpiresAt(expiredTime.getTime()).withIssuedAt(new Date()).sign(Algorithm.HMAC256((String)apiConfig.getJwtSecret()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw Errors.ERROR_OPT_JWT.getException(new Object[0]);
        }
    }

    @Override
    public Map<String, Claim> verfiyJWT(String token) {
        JWTVerifier verifier = null;
        try {
            ApiConfig apiConfig = ApiContext.getApiConfig();
            verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)apiConfig.getJwtSecret())).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw Errors.ERROR_OPT_JWT.getException(new Object[0]);
        }
        DecodedJWT jwt = null;
        try {
            jwt = verifier.verify(token);
        }
        catch (TokenExpiredException e) {
            throw Errors.ERROR_JWT_EXPIRED.getException(new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw Errors.ERROR_JWT.getException(new Object[0]);
        }
        return jwt.getClaims();
    }

    static {
        headerClaims.put("typ", "JWT");
        headerClaims.put("alg", "HS256");
    }
}

