/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.limit;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.bean.ApiDefinition;
import com.gitee.easyopen.bean.DefinitionHolder;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitSearch;
import com.gitee.easyopen.limit.LimitStatus;
import com.gitee.easyopen.util.CopyUtil;
import com.gitee.easyopen.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLimitConfigManager
implements LimitConfigManager {
    private static final String COLUMN_LIMITTYPE = "limitType";
    private static final String COLUMN_LIMITCOUNT = "limitCount";
    private static final String COLUMN_TOKENBUCKETCOUNT = "tokenBucketCount";
    private static final String COLUMN_STATUS = "status";
    private static Map<String, LimitConfig> limitConfigCache = new ConcurrentHashMap<String, LimitConfig>(64);

    protected abstract List<LimitConfig> listFromDb();

    protected abstract int doSave(LimitConfig var1);

    @Override
    public synchronized void loadToLocalCache() {
        limitConfigCache.clear();
        List<LimitConfig> list = this.listFromDb();
        if (list == null) {
            list = Collections.emptyList();
        }
        for (LimitConfig limitConfig : list) {
            String key = limitConfig.getNameVersion();
            limitConfigCache.put(key, limitConfig);
        }
        Map<String, ApiDefinition> allApi = DefinitionHolder.getApiDefinitionMap();
        Set<Map.Entry<String, ApiDefinition>> allDefinitions = allApi.entrySet();
        ApiConfig apiConfig = ApiContext.getApiConfig();
        for (Map.Entry<String, ApiDefinition> entry : allDefinitions) {
            String key = entry.getKey();
            if (limitConfigCache.containsKey(key)) continue;
            LimitConfig limitConfig = this.buildEmptyLimitConfig(entry.getValue(), apiConfig);
            limitConfigCache.put(key, limitConfig);
        }
    }

    @Override
    public void loadLimitCache(String json) {
        if (StringUtils.isEmpty((String)json)) {
            json = "[]";
        }
        List list = JSON.parseArray((String)json, LimitConfig.class);
        this.loadLimitCache(list);
    }

    public void loadLimitCache(List<LimitConfig> list) {
        limitConfigCache.clear();
        if (list == null) {
            list = Collections.emptyList();
        }
        for (LimitConfig limitConfig : list) {
            String key = limitConfig.getNameVersion();
            limitConfigCache.put(key, limitConfig);
        }
        Map<String, ApiDefinition> allApi = DefinitionHolder.getApiDefinitionMap();
        Set<Map.Entry<String, ApiDefinition>> allDefinitions = allApi.entrySet();
        ApiConfig apiConfig = ApiContext.getApiConfig();
        for (Map.Entry<String, ApiDefinition> entry : allDefinitions) {
            String key = entry.getKey();
            if (limitConfigCache.containsKey(key)) continue;
            LimitConfig limitConfig = this.buildEmptyLimitConfig(entry.getValue(), apiConfig);
            limitConfigCache.put(key, limitConfig);
        }
    }

    protected LimitConfig buildEmptyLimitConfig(ApiDefinition apiDefinition, ApiConfig apiConfig) {
        LimitConfig limitConfig = new LimitConfig();
        limitConfig.setName(apiDefinition.getName());
        limitConfig.setVersion(apiDefinition.getVersion());
        limitConfig.setLimitCount(apiConfig.getDefaultLimitCount());
        limitConfig.setTokenBucketCount(apiConfig.getDefaultTokenBucketCount());
        limitConfig.setLimitType(apiConfig.getDefaultLimitType().name());
        limitConfig.setStatus(LimitStatus.CLOSE.getStatus());
        return limitConfig;
    }

    @Override
    public synchronized LimitConfig getApiLimitConfig(String nameVersion) {
        String hashKey = nameVersion;
        return limitConfigCache.get(hashKey);
    }

    @Override
    public int save(LimitConfig limitConfig) {
        String key = limitConfig.getNameVersion();
        LimitConfig configCached = limitConfigCache.get(key);
        CopyUtil.copyPropertiesIgnoreNull(limitConfig, configCached, new String[0]);
        return this.doSave(configCached);
    }

    @Override
    public long getTotal(LimitSearch apiSearch) {
        String name = apiSearch.getName();
        int total = 0;
        Map<String, ApiDefinition> apiDefinitionMap = DefinitionHolder.getApiDefinitionMap();
        if (name == null) {
            return apiDefinitionMap.size();
        }
        Set<String> keys = apiDefinitionMap.keySet();
        for (String key : keys) {
            if (!key.contains(name)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public List<LimitConfig> listLimitConfig(final LimitSearch apiSearch) {
        Collection allLimitConfig = limitConfigCache.values();
        allLimitConfig = CollectionUtils.select(allLimitConfig, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                LimitConfig limitConfig = (LimitConfig)object;
                boolean retName = true;
                boolean retStatus = true;
                boolean retLimitType = true;
                String name = apiSearch.getName();
                Byte status = apiSearch.getStatus();
                String limitType = apiSearch.getLimitType();
                if (StringUtils.isNotEmpty((String)name)) {
                    retName = limitConfig.getNameVersion().contains(apiSearch.getName());
                }
                if (status != null) {
                    boolean bl = retStatus = status.byteValue() == limitConfig.getStatus().byteValue();
                }
                if (StringUtils.isNotEmpty((String)limitType)) {
                    retLimitType = limitType.equals(limitConfig.getLimitType());
                }
                return retName && retStatus && retLimitType;
            }
        });
        ArrayList retList = new ArrayList(allLimitConfig);
        Collections.sort(retList, new Comparator<LimitConfig>(){

            @Override
            public int compare(LimitConfig o1, LimitConfig o2) {
                LimitConfig monitorApiInfo1 = o1;
                LimitConfig monitorApiInfo2 = o2;
                String sortname = apiSearch.getSort();
                String sortorder = apiSearch.getOrder();
                if ("DESC".equalsIgnoreCase(sortorder)) {
                    monitorApiInfo1 = o2;
                    monitorApiInfo2 = o1;
                }
                if (AbstractLimitConfigManager.COLUMN_LIMITTYPE.equals(sortname)) {
                    return monitorApiInfo1.getLimitType().compareTo(monitorApiInfo2.getLimitType());
                }
                if (AbstractLimitConfigManager.COLUMN_LIMITCOUNT.equals(sortname)) {
                    return Double.compare(monitorApiInfo1.getLimitCount().intValue(), monitorApiInfo2.getLimitCount().intValue());
                }
                if (AbstractLimitConfigManager.COLUMN_TOKENBUCKETCOUNT.equals(sortname)) {
                    Integer bucket1Count = monitorApiInfo1.getTokenBucketCount();
                    Integer bucket2Count = monitorApiInfo2.getTokenBucketCount();
                    return Long.compare(bucket1Count == null ? 0L : (long)bucket1Count.intValue(), bucket2Count == null ? 0L : (long)bucket2Count.intValue());
                }
                if (AbstractLimitConfigManager.COLUMN_STATUS.equals(sortname)) {
                    return monitorApiInfo1.getStatus().compareTo(monitorApiInfo2.getStatus());
                }
                return monitorApiInfo1.getNameVersion().compareTo(monitorApiInfo2.getNameVersion());
            }
        });
        int pageIndex = apiSearch.getPage();
        int pageSize = apiSearch.getRows();
        return ListUtil.page(retList, pageIndex, pageSize);
    }

    public Map<String, LimitConfig> getLimitConfigCache() {
        return limitConfigCache;
    }
}

