/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.limit;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.limit.AbstractLimitConfigManager;
import com.gitee.easyopen.limit.LimitConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class ApiLimitConfigRedisManager
extends AbstractLimitConfigManager {
    protected static final String REDIS_KEY = "LimitConfigHash";
    private StringRedisTemplate redisTemplate;

    public ApiLimitConfigRedisManager(StringRedisTemplate redisTemplate) {
        Assert.notNull((Object)redisTemplate, (String)"redisTemplate\u4e0d\u80fd\u4e3anull");
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void loadLocal() {
    }

    @Override
    protected List<LimitConfig> listFromDb() {
        List list = this.redisTemplate.opsForHash().values((Object)REDIS_KEY);
        ArrayList<LimitConfig> ret = new ArrayList<LimitConfig>(list.size());
        for (Object jsonStr : list) {
            ret.add((LimitConfig)JSON.parseObject((String)String.valueOf(jsonStr), LimitConfig.class));
        }
        return ret;
    }

    @Override
    protected int doSave(LimitConfig configCached) {
        String hashKey = configCached.getNameVersion();
        this.redisTemplate.opsForHash().put((Object)REDIS_KEY, (Object)hashKey, (Object)JSON.toJSONString((Object)configCached));
        return 1;
    }
}

