/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.limit;

import com.gitee.easyopen.limit.ApiLimitConfigLocalManager;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitManager;
import com.gitee.easyopen.limit.LimitType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ApiLimitLocalManager
implements LimitManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private LoadingCache<Long, AtomicLong> counter = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, AtomicLong>(){

        public AtomicLong load(Long seconds) throws Exception {
            return new AtomicLong(0L);
        }
    });
    private LimitConfigManager limitConfigManager = new ApiLimitConfigLocalManager();

    public ApiLimitLocalManager() {
    }

    public ApiLimitLocalManager(LoadingCache<Long, AtomicLong> counter, LimitConfigManager limitConfigManager) {
        this(limitConfigManager);
        Assert.notNull(counter, (String)"counter\u4e0d\u80fd\u4e3anull");
        this.counter = counter;
    }

    public ApiLimitLocalManager(LimitConfigManager limitConfigManager) {
        Assert.notNull((Object)limitConfigManager, (String)"limitConfigManager\u4e0d\u80fd\u4e3anull");
        this.limitConfigManager = limitConfigManager;
    }

    @Override
    public double acquireToken(String nameVersion) {
        LimitConfig apiRateConfig = this.limitConfigManager.getApiLimitConfig(nameVersion);
        if (LimitType.LIMIT.name().equals(apiRateConfig.getLimitType())) {
            throw new RuntimeException("\u9650\u5236\u8bf7\u6c42\u6570\u7b56\u7565\u65e0\u6cd5\u8c03\u7528\u6b64\u65b9\u6cd5");
        }
        RateLimiter limiter = apiRateConfig.fatchRateLimiter();
        if (limiter == null) {
            throw new RuntimeException("RateLimiter\u4e0d\u80fd\u4e3anull");
        }
        return limiter.acquire();
    }

    @Override
    public boolean acquire(String nameVersion) {
        LimitConfig apiRateConfig = this.limitConfigManager.getApiLimitConfig(nameVersion);
        int limit = apiRateConfig.getLimitCount();
        long currentSeconds = System.currentTimeMillis() / 1000L;
        try {
            return ((AtomicLong)this.counter.get((Object)currentSeconds)).incrementAndGet() <= (long)limit;
        }
        catch (ExecutionException e) {
            this.logger.error("\u9650\u6d41\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    public LimitConfigManager getLimitConfigManager() {
        return this.limitConfigManager;
    }

    public void setLimitConfigManager(LimitConfigManager limitConfigManager) {
        this.limitConfigManager = limitConfigManager;
    }

    public LoadingCache<Long, AtomicLong> getCounter() {
        return this.counter;
    }

    public void setCounter(LoadingCache<Long, AtomicLong> counter) {
        this.counter = counter;
    }
}

