/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.limit;

import com.gitee.easyopen.limit.ApiLimitConfigRedisManager;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitManager;
import com.gitee.easyopen.limit.LimitType;
import com.google.common.util.concurrent.RateLimiter;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.Assert;

public class ApiLimitManager
implements LimitManager {
    private static final String DEFAULT_LIMIT_LUA_FILE_PATH = "/easyopen_script/limit.lua";
    private static final Long REDIS_SUCCESS = 1L;
    private StringRedisTemplate redisTemplate;
    private String limitScript;
    private String limitScriptSha1;
    private LimitConfigManager limitConfigManager;

    public ApiLimitManager(RedisTemplate redisTemplate) {
        this(redisTemplate, null);
    }

    public ApiLimitManager(RedisTemplate redisTemplate, LimitConfigManager limitConfigManager) {
        Assert.notNull((Object)redisTemplate, (String)"redisTemplate\u4e0d\u80fd\u4e3anull");
        this.redisTemplate = new StringRedisTemplate(redisTemplate.getConnectionFactory());
        ClassPathResource limitLua = new ClassPathResource(this.getLimitLuaFilePath());
        try {
            this.limitScript = IOUtils.toString((InputStream)limitLua.getInputStream(), (String)"UTF-8");
            this.limitScriptSha1 = DigestUtils.sha1Hex((String)this.limitScript);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u811a\u672c\u6587\u4ef6\u5931\u8d25\uff0c\u811a\u672c\u8def\u5f84:" + this.getLimitLuaFilePath(), e);
        }
        if (limitConfigManager == null) {
            limitConfigManager = new ApiLimitConfigRedisManager(this.redisTemplate);
        }
        this.limitConfigManager = limitConfigManager;
    }

    public String getLimitLuaFilePath() {
        return DEFAULT_LIMIT_LUA_FILE_PATH;
    }

    @Override
    public double acquireToken(String nameVersion) {
        LimitConfig apiRateConfig = this.limitConfigManager.getApiLimitConfig(nameVersion);
        if (LimitType.LIMIT.name().equals(apiRateConfig.getLimitType())) {
            throw new RuntimeException("\u9650\u5236\u8bf7\u6c42\u6570\u7b56\u7565\u65e0\u6cd5\u8c03\u7528\u6b64\u65b9\u6cd5");
        }
        RateLimiter limiter = apiRateConfig.fatchRateLimiter();
        if (limiter == null) {
            throw new RuntimeException("RateLimiter\u4e0d\u80fd\u4e3anull");
        }
        return limiter.acquire();
    }

    @Override
    public boolean acquire(String nameVersion) {
        LimitConfig apiRateConfig = this.limitConfigManager.getApiLimitConfig(nameVersion);
        if (LimitType.TOKEN_BUCKET.name().equals(apiRateConfig.getLimitType())) {
            throw new RuntimeException("\u4ee4\u724c\u6876\u7b56\u7565\u65e0\u6cd5\u8c03\u7528\u6b64\u65b9\u6cd5");
        }
        String key = "limit:" + apiRateConfig.getNameVersion();
        int limitCount = apiRateConfig.getLimitCount();
        Object result = this.redisTemplate.execute((RedisScript)new RedisScript<Long>(){

            public String getSha1() {
                return ApiLimitManager.this.limitScriptSha1;
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public String getScriptAsString() {
                return ApiLimitManager.this.limitScript;
            }
        }, Collections.singletonList(key), new Object[]{String.valueOf(limitCount)});
        return REDIS_SUCCESS.equals(result);
    }

    @Override
    public LimitConfigManager getLimitConfigManager() {
        return this.limitConfigManager;
    }

    public void setLimitConfigManager(LimitConfigManager limitConfigManager) {
        this.limitConfigManager = limitConfigManager;
    }
}

