/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.monitor;

import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.bean.ApiSearch;
import com.gitee.easyopen.monitor.MonitorApiInfo;
import com.gitee.easyopen.monitor.MonitorStore;
import com.gitee.easyopen.util.ListUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.springframework.util.StringUtils;

public class ApiMonitorStore
implements MonitorStore {
    private static final String COLUMN_VISITCOUNT = "visitCount";
    private static final String COLUMN_AVGCONSUMEMILLISECONDS = "avgConsumeMilliseconds";
    private static final String COLUMN_MAXCONSUMEMILLISECONDS = "maxConsumeMilliseconds";
    private static final String COLUMN_ERRORCOUNT = "errorCount";
    private Map<String, MonitorApiInfo> store = new HashMap<String, MonitorApiInfo>();

    @Override
    public synchronized void stat(ApiParam param, long starTimeMillis, long endTimeMillis, Object argu, Object result, Exception e) {
        String key = this.getKey(param.fatchName(), param.fatchVersion());
        MonitorApiInfo monitorApiInfo = this.store.get(key);
        if (monitorApiInfo == null) {
            monitorApiInfo = new MonitorApiInfo();
            monitorApiInfo.setName(param.fatchName());
            monitorApiInfo.setVersion(param.fatchVersion());
            this.store.put(key, monitorApiInfo);
        }
        long visitCount = monitorApiInfo.getVisitCount() + 1L;
        long consumeMilliseconds = endTimeMillis - starTimeMillis;
        long sumConsumeMilliseconds = monitorApiInfo.getSumConsumeMilliseconds() + consumeMilliseconds;
        BigDecimal avgConsume = new BigDecimal(sumConsumeMilliseconds).divide(new BigDecimal(visitCount), 2, 0);
        double avgConsumeMilliseconds = avgConsume.doubleValue();
        long maxConsumeMilliseconds = monitorApiInfo.getMaxConsumeMilliseconds();
        int errorCount = monitorApiInfo.getErrorCount();
        if (e != null) {
            this.errorHandler(param, argu, result, e, monitorApiInfo);
            ++errorCount;
        }
        monitorApiInfo.setMaxConsumeMilliseconds(Math.max(consumeMilliseconds, maxConsumeMilliseconds));
        monitorApiInfo.setVisitCount(visitCount);
        monitorApiInfo.setSumConsumeMilliseconds(sumConsumeMilliseconds);
        monitorApiInfo.setAvgConsumeMilliseconds(avgConsumeMilliseconds);
        monitorApiInfo.setErrorCount(errorCount);
    }

    @Override
    public int getTotal(ApiSearch apiSearch) {
        String name = apiSearch.getName();
        int total = 0;
        Set<String> keys = this.store.keySet();
        if (name == null) {
            return keys.size();
        }
        for (String key : keys) {
            if (!key.contains(name)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public List<MonitorApiInfo> getList(final ApiSearch apiSearch) {
        String name = apiSearch.getName();
        Collection<Map.Entry<String, MonitorApiInfo>> entrys = this.store.entrySet();
        if (name != null) {
            entrys = CollectionUtils.select(entrys, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Map.Entry apiInfo = (Map.Entry)object;
                    return ((String)apiInfo.getKey()).contains(apiSearch.getName());
                }
            });
        }
        ArrayList retList = new ArrayList(entrys.size());
        for (Map.Entry entry : entrys) {
            retList.add(entry.getValue());
        }
        Collections.sort(retList, new Comparator<MonitorApiInfo>(){

            @Override
            public int compare(MonitorApiInfo o1, MonitorApiInfo o2) {
                MonitorApiInfo monitorApiInfo1 = o1;
                MonitorApiInfo monitorApiInfo2 = o2;
                String sortname = apiSearch.getSort();
                String sortorder = apiSearch.getOrder();
                if ("DESC".equalsIgnoreCase(sortorder)) {
                    monitorApiInfo1 = o2;
                    monitorApiInfo2 = o1;
                }
                if (ApiMonitorStore.COLUMN_VISITCOUNT.equals(sortname)) {
                    return Long.compare(monitorApiInfo1.getVisitCount(), monitorApiInfo2.getVisitCount());
                }
                if (ApiMonitorStore.COLUMN_AVGCONSUMEMILLISECONDS.equals(sortname)) {
                    return Double.compare(monitorApiInfo1.getAvgConsumeMilliseconds(), monitorApiInfo2.getAvgConsumeMilliseconds());
                }
                if (ApiMonitorStore.COLUMN_MAXCONSUMEMILLISECONDS.equals(sortname)) {
                    return Long.compare(monitorApiInfo1.getMaxConsumeMilliseconds(), monitorApiInfo2.getMaxConsumeMilliseconds());
                }
                if (ApiMonitorStore.COLUMN_ERRORCOUNT.equals(sortname)) {
                    return Integer.compare(monitorApiInfo1.getErrorCount(), monitorApiInfo2.getErrorCount());
                }
                return monitorApiInfo1.getName().compareTo(monitorApiInfo2.getName());
            }
        });
        int pageIndex = apiSearch.getPage();
        int n = apiSearch.getRows();
        return ListUtil.page(retList, pageIndex, n);
    }

    @Override
    public void clean(String name, String version) {
        if (StringUtils.isEmpty((Object)name)) {
            this.store.clear();
        } else {
            String key = this.getKey(name, version);
            this.store.remove(key);
        }
    }

    @Override
    public void errorHandler(ApiParam param, Object argu, Object result, Exception e, MonitorApiInfo t) {
        String errorMsg = this.getErrorMsg(param, argu, result, e);
        this.setErrorMsg(t, errorMsg);
    }

    private String getKey(String name, String version) {
        if (version == null) {
            version = "";
        }
        return ApiParam.buildNameVersion(name, version);
    }

    protected String getErrorMsg(ApiParam param, Object argu, Object result, Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        StringBuilder msg = new StringBuilder();
        String paramStr = param.toJSONString();
        try {
            paramStr = URLDecoder.decode(paramStr, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        msg.append("\u8bf7\u6c42\u53c2\u6570:").append(paramStr).append("\r\n").append("\u9519\u8bef\u4fe1\u606f:").append(writer.toString());
        return msg.toString();
    }

    protected <T extends MonitorApiInfo> void setErrorMsg(T t, String errorMsg) {
        t.getErrors().offer(errorMsg);
    }
}

