/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.monitor;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.exception.BusinessParamException;
import com.gitee.easyopen.interceptor.ApiInterceptorAdapter;
import com.gitee.easyopen.monitor.MonitorStore;
import com.gitee.easyopen.monitor.Visitor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitorInterceptor
extends ApiInterceptorAdapter
implements Visitor {
    private static final String START_TIME = MonitorInterceptor.class.getSimpleName() + "_START_TIME";
    private volatile ExecutorService executorService = null;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu) throws Exception {
        this.in(request, serviceObj, argu);
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu, Object result, Exception e) throws Exception {
        this.out(request, serviceObj, argu, result, e);
    }

    @Override
    public void in(HttpServletRequest request, Object serviceObj, Object argu) {
        request.setAttribute(START_TIME, (Object)System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void out(HttpServletRequest request, Object serviceObj, final Object argu, final Object result, final Exception e) {
        if (e instanceof BusinessParamException) {
            return;
        }
        if (this.executorService == null) {
            Class<MonitorInterceptor> clazz = MonitorInterceptor.class;
            // MONITORENTER : com.gitee.easyopen.monitor.MonitorInterceptor.class
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(ApiContext.getApiConfig().getMonitorExecutorSize());
            }
            // MONITOREXIT : clazz
        }
        final long endTime = System.currentTimeMillis();
        final Long startTime = (Long)request.getAttribute(START_TIME);
        final MonitorStore store = this.getMonitorStore();
        ApiParam param = ApiContext.getApiParam();
        if (param == null) return;
        final ApiParam input = param.clone();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                store.stat(input, startTime, endTime, argu, result, e);
            }
        });
    }

    public MonitorStore getMonitorStore() {
        return ApiContext.getApiConfig().getMonitorStore();
    }
}

