/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.permission;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.permission.ApiInfo;
import com.gitee.easyopen.permission.PermissionManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiPermissionManager
implements PermissionManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, List<String>> appKeyApiMap = new ConcurrentHashMap<String, List<String>>(64);

    @Override
    public synchronized boolean canVisit(String appKey, String name, String version) {
        List<String> clientApis = this.listClientApi(appKey);
        return clientApis.contains(name + version);
    }

    @Override
    public void loadLocal() {
        try {
            this.logger.info("\u5f00\u59cb\u8bfb\u53d6\u672c\u5730\u6743\u9650\u914d\u7f6e\u6587\u4ef6");
            String localFile = ApiContext.getApiConfig().getLocalPermissionConfigFile();
            String configJson = FileUtils.readFileToString((File)new File(localFile), (String)"UTF-8");
            this.loadPermissionCache(configJson);
            this.logger.info("\u672c\u5730\u6743\u9650\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u6210\u529f\uff0c\u8def\u5f84\uff1a{}", (Object)localFile);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6743\u9650\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    @Override
    public void loadPermissionConfig() {
    }

    @Override
    public synchronized void loadPermissionCache(String configJson) {
        if (StringUtils.isEmpty((String)configJson)) {
            configJson = "[]";
        }
        List list = JSON.parseArray((String)configJson, ApiInfo.class);
        appKeyApiMap.clear();
        for (ApiInfo apiInfo : list) {
            String appKey = apiInfo.getApp_key();
            List<String> nameVersionList = appKeyApiMap.get(appKey);
            if (nameVersionList == null) {
                nameVersionList = new ArrayList<String>();
                appKeyApiMap.put(appKey, nameVersionList);
            }
            nameVersionList.add(apiInfo.getName() + apiInfo.getVersion());
        }
    }

    @Override
    public List<String> listClientApi(String appKey) {
        List<String> list = appKeyApiMap.get(appKey);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }
}

