/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.register;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.annotation.Api;
import com.gitee.easyopen.annotation.ApiService;
import com.gitee.easyopen.bean.ApiDefinition;
import com.gitee.easyopen.bean.DefinitionHolder;
import com.gitee.easyopen.doc.ApiDocBuilder;
import com.gitee.easyopen.doc.ApiDocHolder;
import com.gitee.easyopen.doc.ApiServiceDocCreator;
import com.gitee.easyopen.doc.DocFileCreator;
import com.gitee.easyopen.doc.MarkdownDocCreator;
import com.gitee.easyopen.exception.DuplicateApiNameException;
import com.gitee.easyopen.message.ErrorFactory;
import com.gitee.easyopen.register.RegistCallback;
import com.gitee.easyopen.register.SingleParameterContext;
import com.gitee.easyopen.util.FieldUtil;
import com.gitee.easyopen.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ApiRegister {
    private static final Logger logger = LoggerFactory.getLogger(ApiRegister.class);
    private static final ApiMethodFilter API_METHOD_FILTER = new ApiMethodFilter();
    private int apiCount;
    private ApiConfig apiConfig;
    private ApplicationContext applicationContext;

    public ApiRegister(ApiConfig apiConfig, ApplicationContext applicationContext) {
        this.apiConfig = apiConfig;
        this.applicationContext = applicationContext;
    }

    public void regist(RegistCallback registCallback) {
        logger.info("******** \u5f00\u59cb\u6ce8\u518c\u64cd\u4f5c ********");
        this.initMessage();
        this.registApi();
        this.createDoc();
        this.afterRegist(registCallback);
        logger.info("******** \u6ce8\u518c\u64cd\u4f5c\u7ed3\u675f ********");
    }

    private void initMessage() {
        ErrorFactory.initMessageSource(this.apiConfig.getIsvModules());
    }

    private void registApi() {
        String[] beans;
        logger.info("\u5f00\u59cb\u6ce8\u518cApi\u63a5\u53e3...");
        ApplicationContext ctx = this.getApplicationContext();
        Assert.notNull((Object)ctx, (String)"ApplicationContext\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)this.apiConfig, (String)"ApiConfig\u4e0d\u80fd\u4e3a\u7a7a");
        DefinitionHolder.clear();
        for (String beanName : beans = ReflectionUtil.findApiServiceNames(ctx)) {
            Object handler = ctx.getBean(beanName);
            Class handlerClass = ClassUtils.getUserClass((Object)handler);
            ApiRegister.doWithMethods(handlerClass, new ApiMethodProcessor(handler), API_METHOD_FILTER);
        }
        logger.info("\u6ce8\u518cApi\u63a5\u53e3\u5b8c\u6bd5\uff0c\u5171{}\u4e2a\u63a5\u53e3", (Object)this.apiCount);
    }

    private void afterRegist(RegistCallback registCallback) {
        if (registCallback != null) {
            logger.info("\u6267\u884cApi\u6ce8\u518c\u56de\u8c03");
            registCallback.onRegistFinished(this.apiConfig);
            logger.info("\u6267\u884cApi\u6ce8\u518c\u56de\u8c03\u5b8c\u6bd5");
        }
    }

    private static void doWithMethods(Class<?> clazz, ReflectionUtils.MethodCallback mc, ReflectionUtils.MethodFilter mf) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                logger.error("\u6ce8\u518cAPI\u5931\u8d25", (Throwable)ex);
                System.exit(0);
            }
        }
    }

    private void checkTransactionalAnnotation(Method method) throws IllegalAccessException {
        Transactional annotation = (Transactional)AnnotationUtils.findAnnotation((Method)method, Transactional.class);
        if (annotation != null && !Modifier.isPublic(method.getModifiers())) {
            throw new IllegalAccessException("\u65b9\u6cd5" + method + "\u5fc5\u987b\u7533\u660e\u4e3apublic");
        }
    }

    private void createDoc() {
        if (this.apiConfig.getShowDoc().booleanValue()) {
            logger.info("\u751f\u6210\u63a5\u53e3\u6587\u6863");
            new ApiServiceDocCreator(this.apiConfig.getDefaultVersion(), this.applicationContext).create();
        }
        String markdownDocDir = this.apiConfig.getMarkdownDocDir();
        DocFileCreator docFileCreator = this.apiConfig.getDocFileCreator();
        if (docFileCreator == null && StringUtils.isNotBlank((String)markdownDocDir)) {
            docFileCreator = new MarkdownDocCreator(markdownDocDir);
        }
        if (docFileCreator != null) {
            try {
                ApiDocBuilder apiDocBuilder = ApiDocHolder.getApiDocBuilder();
                docFileCreator.createMarkdownDoc(apiDocBuilder.getApiModules());
            }
            catch (IOException e) {
                logger.error("\u751f\u6210\u6587\u6863\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public void setApiConfig(ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private static class ApiMethodFilter
    implements ReflectionUtils.MethodFilter {
        private ApiMethodFilter() {
        }

        public boolean matches(Method method) {
            return !method.isSynthetic() && AnnotationUtils.findAnnotation((Method)method, Api.class) != null;
        }
    }

    private class ApiMethodProcessor
    implements ReflectionUtils.MethodCallback {
        private Object handler;
        private ApiService apiServiceAnno;

        public ApiMethodProcessor(Object handler) {
            this.handler = handler;
            this.apiServiceAnno = (ApiService)AnnotationUtils.findAnnotation(handler.getClass(), ApiService.class);
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            ApiRegister.this.checkTransactionalAnnotation(method);
            ReflectionUtils.makeAccessible((Method)method);
            Api api = (Api)AnnotationUtils.findAnnotation((Method)method, Api.class);
            boolean ignoreSign = api.ignoreSign() ? true : this.apiServiceAnno.ignoreSign();
            boolean ignoreValidate = api.ignoreValidate() ? true : this.apiServiceAnno.ignoreValidate();
            boolean isWrapResult = this.apiServiceAnno.wrapResult() ? api.wrapResult() : false;
            ApiDefinition apiDefinition = new ApiDefinition();
            apiDefinition.setIgnoreSign(ignoreSign);
            apiDefinition.setIgnoreValidate(ignoreValidate);
            apiDefinition.setWrapResult(isWrapResult);
            apiDefinition.setHandler(this.handler);
            apiDefinition.setMethod(method);
            apiDefinition.setName(api.name());
            apiDefinition.setNoReturn(api.noReturn());
            apiDefinition.setIgnoreJWT(api.ignoreJWT());
            apiDefinition.setIgnoreToken(api.isIgnoreToken());
            String version = api.version();
            if ("".equals(version.trim())) {
                version = ApiRegister.this.apiConfig.getDefaultVersion();
            }
            apiDefinition.setVersion(version);
            Parameter[] parameters = method.getParameters();
            Class<?> paramClass = null;
            if (parameters != null && parameters.length > 0) {
                Parameter parameter = parameters[0];
                paramClass = parameter.getType();
                boolean isNumberOrStringType = FieldUtil.isNumberOrStringType(paramClass);
                apiDefinition.setSingleParameter(isNumberOrStringType);
                apiDefinition.setMethodArguClass(paramClass);
                if (isNumberOrStringType) {
                    SingleParameterContext.add(this.handler, method, parameter, api);
                }
            }
            logger.debug("\u6ce8\u518c\u63a5\u53e3name={},version={},method={} {}({})", new Object[]{api.name(), api.version(), method.getReturnType().getName(), method.getName(), paramClass == null ? "" : paramClass.getName()});
            try {
                DefinitionHolder.addApiDefinition(apiDefinition);
                ApiRegister.this.apiConfig.getApiRegistEvent().onSuccess(apiDefinition);
            }
            catch (DuplicateApiNameException e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(0);
            }
            ApiRegister.this.apiCount++;
        }
    }
}

