/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.register;

import com.gitee.easyopen.annotation.Api;
import com.gitee.easyopen.register.SingleParameterWrapper;
import com.gitee.easyopen.util.FieldUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleParameterContext {
    private static final Logger logger = LoggerFactory.getLogger(SingleParameterContext.class);
    private static SingleParameterWrapper singleFieldWrapper = new SingleParameterWrapper();
    private static Map<String, SingleParameterContextValue> context = new ConcurrentHashMap<String, SingleParameterContextValue>(16);

    public static void add(Object handler, Method method, Parameter parameter, Api api) {
        String key = api.name() + api.version();
        String paramName = FieldUtil.getMethodParameterName(handler.getClass(), method, 0);
        Class<?> wrapClass = singleFieldWrapper.wrapParam(parameter, paramName);
        SingleParameterContextValue value = new SingleParameterContextValue();
        value.setHandler(handler);
        value.setMethod(method);
        value.setWrapClass(wrapClass);
        value.setParamName(paramName);
        value.setParameter(parameter);
        logger.info("\u5305\u88c5\u53c2\u6570\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\u540d\uff1a{}", (Object)method, (Object)paramName);
        context.put(key, value);
    }

    public static SingleParameterContextValue get(String name, String version) {
        return context.get(name + version);
    }

    public static void setSingleFieldWrapper(SingleParameterWrapper singleFieldWrapper) {
        SingleParameterContext.singleFieldWrapper = singleFieldWrapper;
    }

    public static class SingleParameterContextValue {
        private Object handler;
        private Method method;
        private String paramName;
        private Parameter parameter;
        private Class<?> wrapClass;

        public Object getHandler() {
            return this.handler;
        }

        public void setHandler(Object handler) {
            this.handler = handler;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public void setParameter(Parameter parameter) {
            this.parameter = parameter;
        }

        public Class<?> getWrapClass() {
            return this.wrapClass;
        }

        public void setWrapClass(Class<?> wrapClass) {
            this.wrapClass = wrapClass;
        }
    }
}

