/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.register;

import com.gitee.easyopen.register.ValidationAnnotationDefinition;
import com.gitee.easyopen.register.ValidationAnnotationDefinitionFactory;
import com.gitee.easyopen.util.FieldUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class SingleParameterWrapper
implements Opcodes {
    private static final Logger logger = LoggerFactory.getLogger(SingleParameterWrapper.class);
    private static final String FOLDER_END_CHAR = "/";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String WRAPPER_PARAM = "WrapperParam";
    private static final String PKG = "com/gitee/easyopen/gen/";
    private static final String OBJECT = "java/lang/Object";
    private static final ParameterClassLoader CLASS_LOADER = new ParameterClassLoader();
    private static AtomicInteger i = new AtomicInteger();
    private String savePath;

    public Class<?> wrapParam(Parameter parameter, String paramName) {
        Annotation[] annotations;
        Class<?> paramType = parameter.getType();
        if (!FieldUtil.isNumberOrStringType(paramType)) {
            return null;
        }
        ClassWriter classWriter = new ClassWriter(0);
        String className = WRAPPER_PARAM + i.incrementAndGet() + paramName;
        String classpathName = PKG + className;
        classWriter.visit(52, 1, classpathName, null, OBJECT, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, OBJECT, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        Type type = Type.getType(paramType);
        FieldVisitor fieldVisitor = classWriter.visitField(1, paramName, type.getDescriptor(), null, null);
        for (Annotation annotation : annotations = AnnotationUtils.getAnnotations((AnnotatedElement)parameter)) {
            ValidationAnnotationDefinition validationAnnotationDefinition = ValidationAnnotationDefinitionFactory.build(annotation);
            if (validationAnnotationDefinition == null) continue;
            Class<?> annoClass = validationAnnotationDefinition.getAnnotationClass();
            Type annoType = Type.getType(annoClass);
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(annoType.getDescriptor(), true);
            Map<String, Object> properties = validationAnnotationDefinition.getProperties();
            if (properties != null) {
                try {
                    Set<Map.Entry<String, Object>> entrySet = properties.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet) {
                        Object val = entry.getValue();
                        if (val == null) continue;
                        if (val.getClass().isEnum()) {
                            Type eType = Type.getType(val.getClass());
                            annotationVisitor.visitEnum(entry.getKey(), eType.getDescriptor(), val.toString());
                            continue;
                        }
                        if (val instanceof Class) {
                            Type vType = Type.getType((Class)((Class)val));
                            annotationVisitor.visit(entry.getKey(), (Object)vType);
                            continue;
                        }
                        annotationVisitor.visit(entry.getKey(), val);
                    }
                }
                catch (Exception e) {
                    logger.error("ASM\u751f\u6210\u6ce8\u89e3\u51fa\u9519", (Throwable)e);
                }
            }
            annotationVisitor.visitEnd();
            logger.info("ASM\u751f\u6210\u53c2\u6570\u6ce8\u89e3\uff0c\u53c2\u6570\uff1a{}\uff0c\u6ce8\u89e3\uff1a{}\uff0c\u6ce8\u89e3\u5c5e\u6027\uff1a{}", new Object[]{paramName, annoClass.getName(), properties});
        }
        fieldVisitor.visitEnd();
        classWriter.visitEnd();
        byte[] code = classWriter.toByteArray();
        if (StringUtils.isNotBlank((String)this.savePath)) {
            if (!this.savePath.endsWith(FOLDER_END_CHAR)) {
                this.savePath = this.savePath + FOLDER_END_CHAR;
            }
            this.writeClassFile(code, this.savePath + className + CLASS_FILE_SUFFIX);
        }
        Class<?> clazz = CLASS_LOADER.defineClass(code);
        logger.info("\u751f\u6210\u53c2\u6570\u5305\u88c5\u7c7b\uff1a{}\uff0c\u5305\u88c5\u53c2\u6570\u540d\uff1a{}\uff0c\u53c2\u6570\u7c7b\u578b\uff1a{}", new Object[]{clazz.getName(), paramName, paramType});
        return clazz;
    }

    protected void writeClassFile(byte[] code, String filepath) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(filepath), (byte[])code);
        }
        catch (IOException e) {
            logger.error("\u5199\u6587\u4ef6\u9519\u8bef\uff0cfilepath:" + filepath, (Throwable)e);
        }
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    static class ParameterClassLoader
    extends ClassLoader {
        public ParameterClassLoader() {
            super(Thread.currentThread().getContextClassLoader());
        }

        public Class<?> defineClass(byte[] clazz) {
            return this.defineClass(null, clazz, 0, clazz.length);
        }
    }
}

