/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.session;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.exception.ApiException;
import com.gitee.easyopen.session.ApiHttpSession;
import com.gitee.easyopen.session.SessionManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSessionManager
implements SessionManager {
    private static Logger logger = LoggerFactory.getLogger(ApiSessionManager.class);
    private int sessionTimeout = 20;
    private volatile LoadingCache<String, HttpSession> cache;

    @Override
    public HttpSession getSession(String sessionId) {
        if (sessionId == null) {
            return this.createSession(sessionId);
        }
        try {
            return (HttpSession)this.getCache().get((Object)sessionId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ApiException("create session error");
        }
    }

    protected HttpSession createSession(String sessionId) {
        ServletContext servletContext = this.getServletContext();
        HttpSession session = this.newSession(sessionId, servletContext);
        session.setMaxInactiveInterval(this.getSessionTimeout());
        this.getCache().put((Object)session.getId(), (Object)session);
        return session;
    }

    protected HttpSession newSession(String sessionId, ServletContext servletContext) {
        return new ApiHttpSession(servletContext, sessionId);
    }

    protected ServletContext getServletContext() {
        return ApiContext.getServletContext();
    }

    protected LoadingCache<String, HttpSession> buildCache() {
        return CacheBuilder.newBuilder().expireAfterAccess((long)this.getSessionTimeout(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, HttpSession>(){

            public HttpSession load(String sessionId) throws Exception {
                return ApiSessionManager.this.createSession(sessionId);
            }
        });
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoadingCache<String, HttpSession> getCache() {
        if (this.cache != null) return this.cache;
        Class<ApiSessionManager> clazz = ApiSessionManager.class;
        synchronized (ApiSessionManager.class) {
            if (this.cache != null) return this.cache;
            this.cache = this.buildCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cache;
        }
    }
}

