/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisHttpSession
implements HttpSession,
Serializable {
    private static final long serialVersionUID = -8081963657251144855L;
    private static final int SEC60 = 60;
    private static final String SESSION_ATTR = "session_attr:";
    private static final String CREATION_TIME = "creationTime";
    private static final String LAST_ACCESSED_TIME = "lastAccessedTime";
    private static final String MAX_INACTIVE_INTERVAL = "maxInactiveInterval";
    private String key;
    private String id;
    private ServletContext servletContext;
    private RedisTemplate redisTemplate;

    private RedisHttpSession() {
    }

    protected static String buildId(String id) {
        return id != null ? id : UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    public static String buildKey(String keyPrefix, String sessionId) {
        Assert.notNull((Object)keyPrefix, (String)"sessionPrefix\u4e0d\u80fd\u4e3anull");
        return keyPrefix + sessionId;
    }

    public static RedisHttpSession createNewSession(ServletContext servletContext, String sessionId, int sessionTimeout, RedisTemplate redisTemplate, String keyPrefix) {
        Assert.notNull((Object)redisTemplate, (String)"redisTemplate can not null.");
        Assert.notNull((Object)sessionId, (String)"sessionId can not null.");
        Assert.notNull((Object)keyPrefix, (String)"keyPrefix can not null.");
        RedisHttpSession redisHttpSession = new RedisHttpSession();
        redisHttpSession.setId(sessionId);
        redisHttpSession.setKey(RedisHttpSession.buildKey(keyPrefix, sessionId));
        redisHttpSession.setRedisTemplate(redisTemplate);
        redisHttpSession.setServletContext(servletContext);
        long creationTime = System.currentTimeMillis();
        int maxInactiveInterval = sessionTimeout * 60;
        redisHttpSession.setCreationTime(creationTime);
        redisHttpSession.setLastAccessedTime(creationTime);
        redisHttpSession.setMaxInactiveInterval(maxInactiveInterval);
        redisHttpSession.refresh();
        return redisHttpSession;
    }

    public static RedisHttpSession createExistSession(String sessionId, ServletContext servletContext, RedisTemplate redisTemplate, String keyPrefix) {
        Assert.notNull((Object)redisTemplate, (String)"redisTemplate can not null.");
        Assert.notNull((Object)sessionId, (String)"sessionId can not null.");
        Assert.notNull((Object)keyPrefix, (String)"keyPrefix can not null.");
        RedisHttpSession redisHttpSession = new RedisHttpSession();
        redisHttpSession.setId(sessionId);
        redisHttpSession.setKey(RedisHttpSession.buildKey(keyPrefix, sessionId));
        redisHttpSession.setRedisTemplate(redisTemplate);
        redisHttpSession.setServletContext(servletContext);
        redisHttpSession.refresh();
        return redisHttpSession;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setCreationTime(long creationTime) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)CREATION_TIME, (Object)String.valueOf(creationTime));
    }

    public long getCreationTime() {
        Object createTime = this.redisTemplate.opsForHash().get((Object)this.key, (Object)CREATION_TIME);
        return Long.valueOf(String.valueOf(createTime));
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        Object lastAccessedTime = this.redisTemplate.opsForHash().get((Object)this.key, (Object)LAST_ACCESSED_TIME);
        return Long.valueOf(String.valueOf(lastAccessedTime));
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)MAX_INACTIVE_INTERVAL, (Object)String.valueOf(interval));
    }

    public int getMaxInactiveInterval() {
        Object maxInactiveInterval = this.redisTemplate.opsForHash().get((Object)this.key, (Object)MAX_INACTIVE_INTERVAL);
        return Integer.valueOf(String.valueOf(maxInactiveInterval));
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.redisTemplate.opsForHash().get((Object)this.key, (Object)(SESSION_ATTR + name));
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeKeys());
    }

    private Set<String> getAttributeKeys() {
        Set keys = this.redisTemplate.opsForHash().keys((Object)this.key);
        HashSet<String> attrNames = new HashSet<String>();
        for (Object key : keys) {
            String k = String.valueOf(key);
            if (!k.startsWith(SESSION_ATTR)) continue;
            attrNames.add(k.substring(SESSION_ATTR.length()));
        }
        return attrNames;
    }

    public String[] getValueNames() {
        return this.getAttributeKeys().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)(SESSION_ATTR + name), value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.redisTemplate.opsForHash().delete((Object)this.key, new Object[]{name});
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.redisTemplate.delete((Object)this.key);
    }

    public boolean isNew() {
        return false;
    }

    public void refresh() {
        this.redisTemplate.expire((Object)this.key, (long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
        this.setLastAccessedTime(System.currentTimeMillis());
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)LAST_ACCESSED_TIME, (Object)String.valueOf(lastAccessedTime));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isInvalidated() {
        return this.redisTemplate.hasKey((Object)this.key) == false;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

