/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.session;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.session.ApiRedisTemplate;
import com.gitee.easyopen.session.RedisHttpSession;
import com.gitee.easyopen.session.SessionManager;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisSessionManager
implements SessionManager {
    private ApiRedisTemplate redisTemplate;
    private int sessionTimeout = 30;
    private String keyPrefix = "session:";

    public RedisSessionManager(RedisTemplate redisTemplate) {
        Assert.notNull((Object)redisTemplate, (String)"RedisSessionManager\u4e2d\u7684redisTemplate\u4e0d\u80fd\u4e3anull");
        this.redisTemplate = new ApiRedisTemplate(redisTemplate.getConnectionFactory());
    }

    @Override
    public HttpSession getSession(String sessionId) {
        return this.getSession(sessionId, this.keyPrefix);
    }

    public HttpSession getSession(String sessionId, String keyPrefix) {
        if (this.hasKey(sessionId)) {
            return RedisHttpSession.createExistSession(sessionId, this.getServletContext(), this.redisTemplate, keyPrefix);
        }
        sessionId = this.buildSessionId(sessionId);
        return RedisHttpSession.createNewSession(this.getServletContext(), sessionId, this.getSessionTimeout(), this.redisTemplate, keyPrefix);
    }

    public String buildSessionId(String id) {
        return id != null ? id : UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    public boolean hasKey(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        String key = RedisHttpSession.buildKey(this.keyPrefix, sessionId);
        return this.redisTemplate.hasKey(key);
    }

    public ServletContext getServletContext() {
        return ApiContext.getServletContext();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public ApiRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(ApiRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

