/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.support;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiResult;
import com.gitee.easyopen.ParamNames;
import com.gitee.easyopen.RespWriter;
import com.gitee.easyopen.Result;
import com.gitee.easyopen.auth.Oauth2Manager;
import com.gitee.easyopen.auth.Oauth2Service;
import com.gitee.easyopen.bean.ApiSearch;
import com.gitee.easyopen.bean.RequestMode;
import com.gitee.easyopen.config.ConfigClient;
import com.gitee.easyopen.doc.ApiDocHolder;
import com.gitee.easyopen.exception.ApiException;
import com.gitee.easyopen.interceptor.ApiInterceptor;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitSearch;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.register.AbstractInitializer;
import com.gitee.easyopen.support.ResponseHandler;
import com.gitee.easyopen.support.VelocityContextHandler;
import com.gitee.easyopen.template.DocTemplate;
import com.gitee.easyopen.template.HandshakeTemplate;
import com.gitee.easyopen.template.InvokeTemplate;
import com.gitee.easyopen.template.LimitTemplate;
import com.gitee.easyopen.template.MonitorTemplate;
import com.gitee.easyopen.template.StatusParam;
import com.gitee.easyopen.template.WebfluxInvokeTemplate;
import com.gitee.easyopen.util.RequestUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.velocity.VelocityContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class ApiController
extends AbstractInitializer
implements ApplicationListener<ContextRefreshedEvent>,
ResponseHandler,
VelocityContextHandler {
    protected static volatile ApplicationContext ctx;
    protected volatile ApiConfig apiConfig;
    private InvokeTemplate invokeTemplate;
    private WebfluxInvokeTemplate webfluxInvokeTemplate;
    private DocTemplate docTemplate;
    private MonitorTemplate monitorTemplate;
    private LimitTemplate limitTemplate;
    private HandshakeTemplate handshakeTemplate;
    @Autowired(required=false)
    protected Oauth2Manager oauth2Manager;
    protected Oauth2Service oauth2Service;

    protected abstract void initApiConfig(ApiConfig var1);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext appCtx = this.getApplicationContext();
        if (appCtx == null) {
            appCtx = event.getApplicationContext();
        }
        this.onStartup(appCtx);
    }

    protected ApplicationContext getApplicationContext() {
        return ctx;
    }

    protected synchronized void onStartup(ApplicationContext applicationContext) {
        if (this.apiConfig != null) {
            return;
        }
        ApiContext.setApplicationContext(applicationContext);
        this.apiConfig = this.newApiConfig();
        ApiContext.setApiConfig(this.apiConfig);
        this.initApiConfig(this.apiConfig);
        this.apiConfig.loadPrivateKey();
        this.initTemplate();
        this.init(applicationContext, this.apiConfig);
        this.initComponent();
    }

    @Override
    public void onRegistFinished(ApiConfig apiConfig) {
        ConfigClient configClient = this.apiConfig.getConfigClient();
        if (configClient != null) {
            configClient.init();
        } else {
            LimitConfigManager limitConfigManager = apiConfig.getLimitConfigManager();
            if (limitConfigManager != null) {
                limitConfigManager.loadToLocalCache();
            }
        }
    }

    protected void initTemplate() {
        this.invokeTemplate = new InvokeTemplate(this.apiConfig, this);
        this.webfluxInvokeTemplate = new WebfluxInvokeTemplate(this.apiConfig, this);
        this.docTemplate = new DocTemplate(this.apiConfig, this);
        this.monitorTemplate = new MonitorTemplate(this.apiConfig, this);
        this.limitTemplate = new LimitTemplate(this.apiConfig, this);
        this.handshakeTemplate = new HandshakeTemplate(this.apiConfig);
    }

    protected ApiConfig newApiConfig() {
        return ApiContext.getApiConfig();
    }

    private void initComponent() {
        if (this.oauth2Manager != null) {
            this.apiConfig.initOauth2Service(this.oauth2Manager);
            this.oauth2Service = this.apiConfig.getOauth2Service();
        }
        this.initInterceptor();
    }

    private void initInterceptor() {
        if (this.apiConfig.getShowMonitor().booleanValue()) {
            ApiInterceptor[] interceptors = this.apiConfig.getInterceptors();
            int len = interceptors.length + 1;
            ApiInterceptor[] newInterceptors = new ApiInterceptor[len];
            newInterceptors[0] = this.apiConfig.getMonitorInerceptor();
            for (int i = 0; i < interceptors.length; ++i) {
                newInterceptors[i + 1] = interceptors[i];
            }
            this.apiConfig.setInterceptors(newInterceptors);
        }
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.GET})
    public void index(HttpServletRequest request, HttpServletResponse response) {
        ApiContext.setRequestMode(RequestMode.SIGNATURE);
        this.invokeTemplate.processInvoke(request, response);
    }

    @RequestMapping(value={"/{name}/"}, method={RequestMethod.POST, RequestMethod.GET})
    public void rest(@PathVariable(value="name") String name, HttpServletRequest request, HttpServletResponse response) {
        this.doRest(name, null, request, response);
    }

    @RequestMapping(value={"/{name}/{version}/"}, method={RequestMethod.POST, RequestMethod.GET})
    public void rest2(@PathVariable(value="name") String name, @PathVariable(value="version") String version, HttpServletRequest request, HttpServletResponse response) {
        this.doRest(name, version, request, response);
    }

    protected void doRest(String name, String version, HttpServletRequest request, HttpServletResponse response) {
        if (name == null) {
            throw new IllegalArgumentException("name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (version == null) {
            version = this.apiConfig.getDefaultVersion();
        }
        request.setAttribute("_REST_PARAM_NAME_", (Object)name);
        request.setAttribute("_REST_PARAM_VERSION_", (Object)version);
        this.index(request, response);
    }

    @RequestMapping(value={"mock"}, method={RequestMethod.POST, RequestMethod.GET})
    public void indexMock(HttpServletRequest request, HttpServletResponse response) {
        ApiContext.setRequestMode(RequestMode.SIGNATURE);
        this.invokeTemplate.processInvokeMock(request, response);
    }

    @RequestMapping(value={"ssl"}, method={RequestMethod.POST})
    public void ssl(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ApiContext.setRequestMode(RequestMode.ENCRYPT);
        this.invokeTemplate.processInvoke(request, response);
    }

    @RequestMapping(value={"ssl2"}, method={RequestMethod.POST})
    public void ssl2(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ApiContext.useNewSSL(request);
        this.invokeTemplate.processInvoke(request, response);
    }

    @Override
    public void responseResult(HttpServletRequest request, HttpServletResponse response, Object result) {
        if (result == null) {
            return;
        }
        RespWriter respWriter = this.apiConfig.getRespWriter();
        respWriter.write(request, response, result);
    }

    @Override
    public Result caugthException(Throwable e) {
        String code = Errors.SYS_ERROR.getCode();
        String msg = e.getMessage();
        Object data = null;
        e = this.apiConfig.getExceptionFormatter().apply(e);
        if (e instanceof ApiException) {
            ApiException apiEx = (ApiException)e;
            code = apiEx.getCode();
            msg = apiEx.getMessage();
            data = apiEx.getData();
        }
        return this.apiConfig.getResultCreator().createErrorResult(code, msg, data);
    }

    @RequestMapping(value={"doc"})
    public void doc(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.docTemplate.processDoc(request, response);
    }

    @RequestMapping(value={"doc/download"})
    public void docDl(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.docTemplate.downloadPdf(request, response);
    }

    @RequestMapping(value={"json/doc"})
    @ResponseBody
    public Map jsondoc(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("apiModules", ApiDocHolder.getApiDocBuilder().getApiModules());
        context.put("ACCESS_TOKEN_NAME", ParamNames.ACCESS_TOKEN_NAME);
        context.put("API_NAME", ParamNames.API_NAME);
        context.put("APP_KEY_NAME", ParamNames.APP_KEY_NAME);
        context.put("DATA_NAME", ParamNames.DATA_NAME);
        context.put("FORMAT_NAME", ParamNames.FORMAT_NAME);
        context.put("SIGN_METHOD_NAME", ParamNames.SIGN_METHOD_NAME);
        context.put("SIGN_NAME", ParamNames.SIGN_NAME);
        context.put("TIMESTAMP_NAME", ParamNames.TIMESTAMP_NAME);
        context.put("TIMESTAMP_PATTERN", ParamNames.TIMESTAMP_PATTERN);
        context.put("VERSION_NAME", ParamNames.VERSION_NAME);
        context.put("code_name", "code");
        context.put("code_description", "\u72b6\u6001\u503c\uff0c\"0\"\u8868\u793a\u6210\u529f\uff0c\u5176\u5b83\u90fd\u662f\u5931\u8d25");
        context.put("msg_name", "msg");
        context.put("msg_description", "\u9519\u8bef\u4fe1\u606f\uff0c\u51fa\u9519\u65f6\u663e\u793a");
        context.put("data_name", "data");
        context.put("data_description", "\u8fd4\u56de\u7684\u6570\u636e\uff0c\u6ca1\u6709\u5219\u8fd4\u56de{}");
        return context;
    }

    @RequestMapping(value={"doc/pwd"})
    @ResponseBody
    public Map docPwd(String password, HttpServletRequest request) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.apiConfig.getDocPassword().equals(password)) {
            map.put("code", 0);
            map.put("msg", "\u9a8c\u8bc1\u6210\u529f");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", "doc");
            data.put("username", RequestUtil.getClientIP(request));
            String jwt = ApiContext.createJwt(data);
            map.put("jwt", jwt);
        } else {
            map.put("code", 1);
            map.put("msg", "\u9a8c\u8bc1\u5931\u8d25");
        }
        return map;
    }

    @RequestMapping(value={"monitor"})
    public void monitor(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.monitorTemplate.processMonitor(request, response);
    }

    @RequestMapping(value={"monitor/data"})
    @ResponseBody
    public Object monitorData(ApiSearch apiSearch, HttpServletRequest request) throws IOException {
        return this.monitorTemplate.monitorData(apiSearch, request);
    }

    @RequestMapping(value={"monitor/del"})
    @ResponseBody
    public Object monitorDel(String name, String version) throws IOException {
        return this.monitorTemplate.monitorDel(name, version);
    }

    @RequestMapping(value={"handshake"}, method={RequestMethod.POST})
    @ResponseBody
    public Object handshake(HttpServletRequest request, HttpServletResponse response) {
        return this.handshakeTemplate.handshake(request, response);
    }

    @RequestMapping(value={"handshake2"}, method={RequestMethod.POST})
    @ResponseBody
    public Object handshake2(HttpServletRequest request, HttpServletResponse response) {
        return this.handshakeTemplate.handshake2(request, response);
    }

    @RequestMapping(value={"authorize"})
    public Object authorize(HttpServletRequest request, HttpServletResponse resp) throws URISyntaxException, OAuthSystemException {
        OAuthResponse response = this.oauth2Service.authorize(request, resp, this.apiConfig);
        if (response == null) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(new URI(response.getLocationUri()));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.valueOf((int)response.getResponseStatus()));
    }

    @RequestMapping(value={"accessToken"})
    public HttpEntity<?> accessToken(HttpServletRequest request) throws URISyntaxException, OAuthSystemException {
        OAuthResponse response = this.oauth2Service.accessToken(request, this.apiConfig);
        return new ResponseEntity((Object)response.getBody(), HttpStatus.valueOf((int)response.getResponseStatus()));
    }

    @ExceptionHandler(value={Throwable.class})
    public void jsonErrorHandler(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        this.logger.error("jsonErrorHandler error", e);
        ApiResult result = new ApiResult();
        result.setCode(Errors.SYS_ERROR.getCode());
        result.setMsg(e.getMessage());
        try {
            this.apiConfig.getRespWriter().write(request, response, result);
        }
        catch (Exception e1) {
            this.logger.error("com.gitee.easyopen.support.ApiController.jsonErrorHandler()\u5199json\u5931\u8d25", (Throwable)e1);
        }
    }

    public void setInvokeTemplate(InvokeTemplate invokeTemplate) {
        this.invokeTemplate = invokeTemplate;
    }

    public void setWebfluxInvokeTemplate(WebfluxInvokeTemplate webfluxInvokeTemplate) {
        this.webfluxInvokeTemplate = webfluxInvokeTemplate;
    }

    @RequestMapping(value={"limit"})
    public void limit(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.limitTemplate.processLimit(request, response);
    }

    @RequestMapping(value={"limit/data"})
    @ResponseBody
    public Object limitData(LimitSearch apiSearch, HttpServletRequest request) throws IOException {
        return this.limitTemplate.limitData(apiSearch, request);
    }

    @RequestMapping(value={"limit/modify"})
    @ResponseBody
    public Object limitModify(LimitConfig limitConfig, HttpServletRequest request) throws IOException {
        return this.limitTemplate.limitModify(limitConfig, request);
    }

    @RequestMapping(value={"limit/status"})
    @ResponseBody
    public Object limitStatus(@RequestBody StatusParam statusParam, HttpServletRequest request) throws IOException {
        return this.limitTemplate.limitStatus(statusParam, request);
    }

    @Override
    public void processDocVelocityContext(VelocityContext context) {
    }

    @Override
    public void processLimitVelocityContext(VelocityContext context) {
    }

    @Override
    public void processMonitorVelocityContext(VelocityContext context) {
    }

    @Override
    public String getDocRemark() {
        return "";
    }

    public InvokeTemplate getInvokeTemplate() {
        return this.invokeTemplate;
    }

    public WebfluxInvokeTemplate getWebfluxInvokeTemplate() {
        return this.webfluxInvokeTemplate;
    }

    public DocTemplate getDocTemplate() {
        return this.docTemplate;
    }

    public void setDocTemplate(DocTemplate docTemplate) {
        this.docTemplate = docTemplate;
    }

    public MonitorTemplate getMonitorTemplate() {
        return this.monitorTemplate;
    }

    public void setMonitorTemplate(MonitorTemplate monitorTemplate) {
        this.monitorTemplate = monitorTemplate;
    }

    public LimitTemplate getLimitTemplate() {
        return this.limitTemplate;
    }

    public void setLimitTemplate(LimitTemplate limitTemplate) {
        this.limitTemplate = limitTemplate;
    }

    public HandshakeTemplate getHandshakeTemplate() {
        return this.handshakeTemplate;
    }

    public void setHandshakeTemplate(HandshakeTemplate handshakeTemplate) {
        this.handshakeTemplate = handshakeTemplate;
    }

    @Component
    private static class Ctx
    implements ApplicationContextAware {
        private Ctx() {
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            ctx = applicationContext;
        }
    }
}

