/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.support;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiResult;
import com.gitee.easyopen.Result;
import com.gitee.easyopen.interceptor.ApiInterceptorAdapter;
import com.gitee.easyopen.util.RedisLockUtil;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public abstract class BaseLockInterceptor
extends ApiInterceptorAdapter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REQUEST_ID_NAME = "easyopen_lock_request_id";
    private static final int ERROR_CODE = -102;
    private static final String ERROR_MSG = "\u60a8\u5df2\u63d0\u4ea4\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u54e6";
    private static final int LOCK_EXPIRE_MILLISECONDS = 60000;

    protected abstract RedisTemplate getRedisTemplate();

    protected abstract String getUserId();

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu) throws Exception {
        String id = this.getUserId();
        if (StringUtils.isEmpty((Object)id) || "null".equals(id)) {
            return true;
        }
        String lockKey = this.getLockKey(id);
        String requestId = UUID.randomUUID().toString();
        boolean hasLock = RedisLockUtil.tryGetDistributedLock(this.getRedisTemplate(), lockKey, requestId, this.getLockExpireMilliseconds());
        if (hasLock) {
            request.setAttribute(REQUEST_ID_NAME, (Object)requestId);
            return true;
        }
        this.noLockHandler(request, response);
        return false;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu, Object result, Exception e) throws Exception {
        String requestId = (String)request.getAttribute(REQUEST_ID_NAME);
        if (StringUtils.hasText((String)requestId)) {
            String id = this.getUserId();
            String lockKey = this.getLockKey(id);
            RedisLockUtil.releaseDistributedLock(this.getRedisTemplate(), lockKey, requestId);
        }
    }

    protected void noLockHandler(HttpServletRequest request, HttpServletResponse response) {
        Result result = this.getErrorResult();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        try {
            response.getWriter().write(JSON.toJSONString((Object)result));
        }
        catch (IOException e) {
            this.log.error("response.getWriter().write\u62a5\u9519", (Throwable)e);
        }
    }

    protected Result getErrorResult() {
        ApiResult result = new ApiResult();
        result.setCode(this.getErrorCode());
        result.setMsg(this.getErrorMsg());
        return result;
    }

    protected int getLockExpireMilliseconds() {
        return 60000;
    }

    protected Object getErrorCode() {
        return -102;
    }

    protected String getErrorMsg() {
        return ERROR_MSG;
    }

    protected String getLockKey(String userId) {
        return "easyopen_lock_key:" + userId;
    }
}

