/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.support;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.ApiRespWriter;
import com.gitee.easyopen.ApiResult;
import com.gitee.easyopen.interceptor.ApiInterceptorAdapter;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitManager;
import com.gitee.easyopen.limit.LimitType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LimitInterceptor
extends ApiInterceptorAdapter {
    private static final byte STATUS_OPEN = 1;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu) throws Exception {
        ApiParam param;
        String nameVersion;
        ApiConfig apiConfig = ApiContext.getApiConfig();
        LimitManager limitManager = apiConfig.getLimitManager();
        if (limitManager == null) {
            this.logger.warn("\u9650\u6d41LimitManager\u4e3anull\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
            return true;
        }
        LimitConfigManager limitConfigManager = limitManager.getLimitConfigManager();
        LimitConfig limitConfig = limitConfigManager.getApiLimitConfig(nameVersion = (param = ApiContext.getApiParam()).fatchNameVersion());
        if (limitConfig.getStatus() == 1) {
            if (limitConfig.getLimitType().equals(LimitType.LIMIT.name())) {
                boolean canNext = limitManager.acquire(nameVersion);
                if (canNext) {
                    return true;
                }
                ApiResult result = new ApiResult();
                result.setCode(limitConfig.getLimitCode());
                result.setMsg(limitConfig.getLimitMsg());
                ApiRespWriter.doWriter(response, "application/json;charset=UTF-8", JSON.toJSONString((Object)result));
                return false;
            }
            double waitSeconds = limitManager.acquireToken(nameVersion);
            this.afterAcquireToken(waitSeconds);
            return true;
        }
        return true;
    }

    protected void afterAcquireToken(double waitSeconds) {
    }
}

