/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.support;

import com.gitee.easyopen.ApiContext;
import com.gitee.easyopen.ApiParam;
import com.gitee.easyopen.exception.ApiException;
import com.gitee.easyopen.interceptor.ApiInterceptorAdapter;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.permission.PermissionManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PermissionInterceptor
extends ApiInterceptorAdapter {
    private ApiException exception = new ApiException(Errors.NO_PERMISSION.getMsg(), Errors.NO_PERMISSION.getCode());

    public PermissionInterceptor() {
    }

    public PermissionInterceptor(String code, String msg) {
        this.exception = new ApiException(msg, code);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object serviceObj, Object argu) throws Exception {
        PermissionManager permissionManager = ApiContext.getApiConfig().getPermissionManager();
        if (permissionManager == null) {
            this.logger.warn("\u6743\u9650PermissionManager\u4e3anull\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\uff01");
            return true;
        }
        ApiParam param = ApiContext.getApiParam();
        boolean canVisit = permissionManager.canVisit(param.fatchAppKey(), param.fatchName(), param.fatchVersion());
        if (!canVisit) {
            throw this.exception;
        }
        return canVisit;
    }
}

