/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.template;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.support.VelocityContextHandler;
import com.gitee.easyopen.template.AbstractTemplate;
import com.gitee.easyopen.util.VelocityUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractVelocityContextTemplate
extends AbstractTemplate {
    protected VelocityContextHandler velocityContextHandler;

    public AbstractVelocityContextTemplate(ApiConfig apiConfig, VelocityContextHandler velocityContextHandler) {
        super(apiConfig);
        this.velocityContextHandler = velocityContextHandler;
    }

    protected VelocityContext buildVelocityContext(HttpServletRequest request) {
        VelocityContext context = new VelocityContext();
        String requestUrl = request.getRequestURL().toString();
        context.put("url", (Object)requestUrl);
        context.put("ctx", (Object)request.getContextPath());
        context.put("loginUrl", (Object)this.getLoginUrl(requestUrl));
        return context;
    }

    protected String getLoginUrl(String requestUrl) {
        return requestUrl.substring(requestUrl.lastIndexOf("/") + 1);
    }

    protected boolean checkPassword(HttpServletRequest request, String serverPwd) {
        String inputPassword = request.getParameter("p");
        if (inputPassword == null) {
            return false;
        }
        if (serverPwd == null) {
            return false;
        }
        return DigestUtils.md5Hex((String)serverPwd).equals(inputPassword);
    }

    protected void toHtml(VelocityContext context, ClassPathResource res, HttpServletResponse response) throws IOException {
        VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
    }
}

