/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.template;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ParamNames;
import com.gitee.easyopen.doc.ApiDocBuilder;
import com.gitee.easyopen.doc.ApiDocHolder;
import com.gitee.easyopen.support.VelocityContextHandler;
import com.gitee.easyopen.template.AbstractVelocityContextTemplate;
import com.gitee.easyopen.util.PDFUtil;
import com.gitee.easyopen.util.VelocityUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class DocTemplate
extends AbstractVelocityContextTemplate {
    private static final String SESSION_KEY_DOC_PASSWORD = "session_key_doc_password";

    public DocTemplate(ApiConfig apiConfig, VelocityContextHandler velocityContextHandler) {
        super(apiConfig, velocityContextHandler);
    }

    public void processDoc(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        if (!this.apiConfig.getShowDoc().booleanValue()) {
            response.getWriter().write("\u6587\u6863\u529f\u80fd\u672a\u5f00\u542f");
            return;
        }
        Object value = request.getSession().getAttribute(SESSION_KEY_DOC_PASSWORD);
        VelocityContext context = this.buildVelocityContext(request);
        String requestUrl = request.getRequestURL().toString();
        context.put("apiUrl", (Object)requestUrl.subSequence(0, requestUrl.length() - 4));
        if (StringUtils.hasText((String)this.apiConfig.getDocPassword()) && value == null) {
            if (this.checkDocPassword(request)) {
                request.getSession().setAttribute(SESSION_KEY_DOC_PASSWORD, (Object)true);
                response.sendRedirect(String.valueOf(context.get("loginUrl")));
                return;
            }
            ClassPathResource res = new ClassPathResource(this.apiConfig.getLoginClassPath());
            context.put("title", (Object)"API\u6587\u6863");
            context.put("remark", (Object)"\u6587\u6863\u9875\u9762\u5bc6\u7801\uff1a");
            VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
            return;
        }
        ClassPathResource res = new ClassPathResource(this.apiConfig.getDocClassPath());
        context.put("title", (Object)"API\u6587\u6863");
        ApiDocBuilder docBuilder = ApiDocHolder.getApiDocBuilder();
        context.put("apiModules", docBuilder.getApiModules());
        context.put("ACCESS_TOKEN_NAME", (Object)ParamNames.ACCESS_TOKEN_NAME);
        context.put("API_NAME", (Object)ParamNames.API_NAME);
        context.put("APP_KEY_NAME", (Object)ParamNames.APP_KEY_NAME);
        context.put("DATA_NAME", (Object)ParamNames.DATA_NAME);
        context.put("FORMAT_NAME", (Object)ParamNames.FORMAT_NAME);
        context.put("SIGN_METHOD_NAME", (Object)ParamNames.SIGN_METHOD_NAME);
        context.put("SIGN_NAME", (Object)ParamNames.SIGN_NAME);
        context.put("TIMESTAMP_NAME", (Object)ParamNames.TIMESTAMP_NAME);
        context.put("TIMESTAMP_PATTERN", (Object)ParamNames.TIMESTAMP_PATTERN);
        context.put("VERSION_NAME", (Object)ParamNames.VERSION_NAME);
        context.put("code_name", (Object)"code");
        context.put("code_description", (Object)"\u72b6\u6001\u503c\uff0c\"0\"\u8868\u793a\u6210\u529f\uff0c\u5176\u5b83\u90fd\u662f\u5931\u8d25");
        context.put("msg_name", (Object)"msg");
        context.put("msg_description", (Object)"\u9519\u8bef\u4fe1\u606f\uff0c\u51fa\u9519\u65f6\u663e\u793a");
        context.put("data_name", (Object)"data");
        context.put("data_description", (Object)"\u8fd4\u56de\u7684\u6570\u636e\uff0c\u6ca1\u6709\u5219\u8fd4\u56de{}");
        context.put("docRemark", (Object)this.velocityContextHandler.getDocRemark());
        context.put("jsHook", (Object)"");
        context.put("sys_time", (Object)System.currentTimeMillis());
        context.put("is_expand_all", (Object)true);
        this.processDocVelocityContext(context);
        this.toHtml(context, res, response);
    }

    public void downloadPdf(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.apiConfig.getShowDoc().booleanValue()) {
            response.getWriter().write("\u6587\u6863\u529f\u80fd\u672a\u5f00\u542f");
            return;
        }
        Object value = request.getSession().getAttribute(SESSION_KEY_DOC_PASSWORD);
        VelocityContext context = this.buildVelocityContext(request);
        if (StringUtils.hasText((String)this.apiConfig.getDocPassword()) && value == null) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html; charset=UTF-8");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            if (this.checkDocPassword(request)) {
                request.getSession().setAttribute(SESSION_KEY_DOC_PASSWORD, (Object)true);
                response.sendRedirect(String.valueOf(context.get("loginUrl")));
            } else {
                ClassPathResource res = new ClassPathResource(this.apiConfig.getLoginClassPath());
                context.put("title", (Object)"API\u6587\u6863");
                context.put("remark", (Object)"\u6587\u6863\u9875\u9762\u5bc6\u7801\uff1a");
                VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
            }
            return;
        }
        ClassPathResource res = new ClassPathResource(this.apiConfig.getDocPdfClassPath());
        ClassPathResource cssRes = new ClassPathResource(this.apiConfig.getDocPdfCssClassPath());
        context.put("title", (Object)"API\u6587\u6863");
        ApiDocBuilder docBuilder = ApiDocHolder.getApiDocBuilder();
        context.put("apiModules", docBuilder.getApiModules());
        context.put("ACCESS_TOKEN_NAME", (Object)ParamNames.ACCESS_TOKEN_NAME);
        context.put("API_NAME", (Object)ParamNames.API_NAME);
        context.put("APP_KEY_NAME", (Object)ParamNames.APP_KEY_NAME);
        context.put("DATA_NAME", (Object)ParamNames.DATA_NAME);
        context.put("FORMAT_NAME", (Object)ParamNames.FORMAT_NAME);
        context.put("SIGN_METHOD_NAME", (Object)ParamNames.SIGN_METHOD_NAME);
        context.put("SIGN_NAME", (Object)ParamNames.SIGN_NAME);
        context.put("TIMESTAMP_NAME", (Object)ParamNames.TIMESTAMP_NAME);
        context.put("TIMESTAMP_PATTERN", (Object)ParamNames.TIMESTAMP_PATTERN);
        context.put("VERSION_NAME", (Object)ParamNames.VERSION_NAME);
        context.put("code_name", (Object)"code");
        context.put("code_description", (Object)"\u72b6\u6001\u503c\uff0c\"0\"\u8868\u793a\u6210\u529f\uff0c\u5176\u5b83\u90fd\u662f\u5931\u8d25");
        context.put("msg_name", (Object)"msg");
        context.put("msg_description", (Object)"\u9519\u8bef\u4fe1\u606f\uff0c\u51fa\u9519\u65f6\u663e\u793a");
        context.put("data_name", (Object)"data");
        context.put("data_description", (Object)"\u8fd4\u56de\u7684\u6570\u636e\uff0c\u6ca1\u6709\u5219\u8fd4\u56de{}");
        context.put("docRemark", (Object)this.velocityContextHandler.getDocRemark());
        context.put("fileName", (Object)("API\u6587\u6863" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".pdf"));
        this.processDocVelocityContext(context);
        String fileName = URLEncoder.encode((String)context.get("fileName"), "UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setContentType("application/octet-stream;charset=UTF-8");
        String content = VelocityUtil.generateToString(context, res.getInputStream());
        String css = IOUtils.toString((InputStream)cssRes.getInputStream(), (String)"UTF-8");
        PDFUtil.htmlToPDF(content, css, (OutputStream)response.getOutputStream(), (PDFUtil.PDFInfo)context.get("pdf_info"));
    }

    public boolean checkDocPassword(HttpServletRequest request) {
        return this.checkPassword(request, this.apiConfig.getDocPassword());
    }

    protected void processDocVelocityContext(VelocityContext context) {
        this.velocityContextHandler.processDocVelocityContext(context);
    }
}

