/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.template;

import com.alibaba.fastjson.JSON;
import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiResult;
import com.gitee.easyopen.AppSecretManager;
import com.gitee.easyopen.Encrypter;
import com.gitee.easyopen.LocalAppSecretManager;
import com.gitee.easyopen.bean.HandshakeParam;
import com.gitee.easyopen.bean.Secret;
import com.gitee.easyopen.message.Errors;
import com.gitee.easyopen.template.AbstractTemplate;
import com.gitee.easyopen.util.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class HandshakeTemplate
extends AbstractTemplate {
    public HandshakeTemplate(ApiConfig apiConfig) {
        super(apiConfig);
    }

    public Object handshake(HttpServletRequest request, HttpServletResponse response) {
        try {
            String randomKeyEncrypted = RequestUtil.getText(request);
            Encrypter encrypter = this.apiConfig.getEncrypter();
            String privateKey = this.apiConfig.getPrivateKey();
            if (StringUtils.isEmpty((Object)privateKey)) {
                this.logger.error("\u672a\u8bbe\u7f6e\u6b63\u786e\u7684\u79c1\u94a5");
                throw Errors.ERROR_SSL.getException(new Object[0]);
            }
            String randomKey = encrypter.rsaDecryptByPrivateKey(randomKeyEncrypted, privateKey);
            request.getSession().setAttribute("ssl_randomKey", (Object)randomKey);
            String retContent = "0";
            String aesStr = encrypter.aesEncryptToHex(retContent, randomKey);
            String data = encrypter.rsaEncryptByPrivateKey(aesStr, privateKey);
            ApiResult result = new ApiResult();
            result.setCode(Errors.SUCCESS.getCode());
            result.setData(data);
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            ApiResult result = new ApiResult();
            result.setCode(Errors.ERROR_SSL.getCode());
            result.setMsg("\u4ea4\u4e92\u9519\u8bef");
            return result;
        }
    }

    public Object handshake2(HttpServletRequest request, HttpServletResponse response) {
        try {
            String json = RequestUtil.getText(request);
            HandshakeParam handshakeParam = (HandshakeParam)JSON.parseObject((String)json, HandshakeParam.class);
            String privateKey = null;
            AppSecretManager appSecretManager = this.apiConfig.getAppSecretManager();
            if (appSecretManager instanceof LocalAppSecretManager) {
                LocalAppSecretManager localAppSecretManager = (LocalAppSecretManager)appSecretManager;
                Secret secret = localAppSecretManager.getSecretInfo(handshakeParam.getApp_key());
                if (secret == null) {
                    return ApiResult.error(Errors.ERROR_APP_ID);
                }
                privateKey = secret.getPriKey();
            } else {
                privateKey = this.apiConfig.getPrivateKey();
            }
            if (StringUtils.isEmpty((Object)privateKey)) {
                this.logger.error("\u672a\u8bbe\u7f6e\u6b63\u786e\u7684\u79c1\u94a5");
                throw Errors.ERROR_SSL.getException(new Object[0]);
            }
            Encrypter encrypter = this.apiConfig.getEncrypter();
            String randomKeyEncrypted = handshakeParam.getData();
            String randomKey = encrypter.rsaDecryptByPrivateKeyNew(randomKeyEncrypted, privateKey);
            request.getSession().setAttribute("ssl_randomKey", (Object)randomKey);
            String retContent = encrypter.md5(randomKey);
            String aesStr = encrypter.aesEncryptToBase64String(retContent, randomKey);
            String data = encrypter.rsaEncryptByPrivateKeyNew(aesStr, privateKey);
            return ApiResult.success(data);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return ApiResult.error(Errors.ERROR_SSL);
        }
    }
}

