/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.template;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.ApiValidator;
import com.gitee.easyopen.exception.ApiException;
import com.gitee.easyopen.limit.LimitConfig;
import com.gitee.easyopen.limit.LimitConfigManager;
import com.gitee.easyopen.limit.LimitSearch;
import com.gitee.easyopen.support.VelocityContextHandler;
import com.gitee.easyopen.template.AbstractVelocityContextTemplate;
import com.gitee.easyopen.template.StatusParam;
import com.gitee.easyopen.util.VelocityUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.RequestBody;

public class LimitTemplate
extends AbstractVelocityContextTemplate {
    private static final int SYSTEM_MAX_CODE = 100;
    private static final String SESSION_KEY_LIMIT_PASSWORD = "session_key_limit_password";

    public LimitTemplate(ApiConfig apiConfig, VelocityContextHandler velocityContextHandler) {
        super(apiConfig, velocityContextHandler);
    }

    public void processLimit(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.apiConfig.getLimitManager() == null) {
            response.getWriter().write("\u9650\u6d41\u529f\u80fd\u672a\u5f00\u542f");
            return;
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Object value = request.getSession().getAttribute(SESSION_KEY_LIMIT_PASSWORD);
        VelocityContext context = this.buildVelocityContext(request);
        if (value == null) {
            if (this.checkLimitPassword(request)) {
                request.getSession().setAttribute(SESSION_KEY_LIMIT_PASSWORD, (Object)true);
                response.sendRedirect(String.valueOf(context.get("loginUrl")));
            } else {
                request.getSession().setAttribute(SESSION_KEY_LIMIT_PASSWORD, null);
                ClassPathResource res = new ClassPathResource(this.apiConfig.getLoginClassPath());
                context.put("title", (Object)"\u9650\u6d41\u7ba1\u7406");
                context.put("remark", (Object)"\u9650\u6d41\u7ba1\u7406\u9875\u9762\u5bc6\u7801\uff1a");
                VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
            }
        } else {
            ClassPathResource res = new ClassPathResource(this.apiConfig.getLimitClassPath());
            context.put("title", (Object)"\u9650\u6d41\u7ba1\u7406");
            this.processLimitVelocityContext(context);
            VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
        }
    }

    public Object limitData(LimitSearch apiSearch, HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_KEY_LIMIT_PASSWORD) == null) {
            return -1;
        }
        LimitConfigManager limitConfigManager = this.apiConfig.getLimitConfigManager();
        long total = limitConfigManager.getTotal(apiSearch);
        List<LimitConfig> list = limitConfigManager.listLimitConfig(apiSearch);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", total);
        map.put("rows", list);
        return map;
    }

    public Object limitModify(LimitConfig limitConfig, HttpServletRequest request) {
        int codeDouble;
        Set validateRet;
        if (request.getSession().getAttribute(SESSION_KEY_LIMIT_PASSWORD) == null) {
            return -1;
        }
        if (StringUtils.isBlank((String)limitConfig.getVersion())) {
            limitConfig.setVersion("");
        }
        if (CollectionUtils.isNotEmpty((Collection)(validateRet = ApiValidator.getValidator().validate((Object)limitConfig, new Class[0])))) {
            ConstraintViolation oneError = (ConstraintViolation)validateRet.iterator().next();
            String errorMsg = oneError.getMessage();
            throw new ApiException(errorMsg, "500");
        }
        String code = limitConfig.getLimitCode();
        if (NumberUtils.isNumber((String)code) && (codeDouble = NumberUtils.toInt((String)code)) <= 100) {
            throw new ApiException("code\u503c\u5fc5\u987b\u5927\u4e8e100\uff081~100\u4e3a\u7cfb\u7edf\u4fdd\u7559code\uff09", "500");
        }
        LimitConfigManager limitConfigManager = this.apiConfig.getLimitConfigManager();
        limitConfigManager.save(limitConfig);
        return Collections.emptyMap();
    }

    public Object limitStatus(@RequestBody StatusParam statusParam, HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_KEY_LIMIT_PASSWORD) == null) {
            return -1;
        }
        List<String> list = statusParam.getNameVersionList();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        if (statusParam.getStatus() == null) {
            throw new ApiException("status\u4e0d\u80fd\u4e3anull", "500");
        }
        LimitConfigManager limitConfigManager = this.apiConfig.getLimitConfigManager();
        byte status = statusParam.getStatus();
        for (String nameVersion : list) {
            LimitConfig limitConfig = limitConfigManager.getApiLimitConfig(nameVersion);
            if (limitConfig.getStatus() == status) continue;
            limitConfig.setStatus(status);
            limitConfigManager.save(limitConfig);
        }
        return Collections.emptyMap();
    }

    protected void processLimitVelocityContext(VelocityContext context) {
        this.velocityContextHandler.processLimitVelocityContext(context);
    }

    protected boolean checkLimitPassword(HttpServletRequest request) {
        return this.checkPassword(request, this.apiConfig.getLimitPassword());
    }
}

