/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.template;

import com.gitee.easyopen.ApiConfig;
import com.gitee.easyopen.bean.ApiSearch;
import com.gitee.easyopen.monitor.MonitorApiInfo;
import com.gitee.easyopen.monitor.MonitorStore;
import com.gitee.easyopen.support.VelocityContextHandler;
import com.gitee.easyopen.template.AbstractVelocityContextTemplate;
import com.gitee.easyopen.util.VelocityUtil;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ClassPathResource;

public class MonitorTemplate
extends AbstractVelocityContextTemplate {
    private static final String SESSION_KEY_MONITOR_PASSWORD = "session_key_monitor_password";

    public MonitorTemplate(ApiConfig apiConfig, VelocityContextHandler velocityContextHandler) {
        super(apiConfig, velocityContextHandler);
    }

    public void processMonitor(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (!this.apiConfig.getShowMonitor().booleanValue()) {
            response.getWriter().write("\u76d1\u63a7\u529f\u80fd\u672a\u5f00\u542f");
            return;
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Object value = request.getSession().getAttribute(SESSION_KEY_MONITOR_PASSWORD);
        VelocityContext context = this.buildVelocityContext(request);
        if (value == null) {
            if (this.checkMonitorPassword(request)) {
                request.getSession().setAttribute(SESSION_KEY_MONITOR_PASSWORD, (Object)true);
                response.sendRedirect(String.valueOf(context.get("loginUrl")));
                return;
            }
            request.getSession().setAttribute(SESSION_KEY_MONITOR_PASSWORD, null);
            ClassPathResource res = new ClassPathResource(this.apiConfig.getLoginClassPath());
            context.put("title", (Object)"API\u76d1\u63a7");
            context.put("remark", (Object)"\u76d1\u63a7\u9875\u9762\u5bc6\u7801\uff1a");
            VelocityUtil.generate(context, res.getInputStream(), (Writer)response.getWriter());
            return;
        }
        ClassPathResource res = new ClassPathResource(this.apiConfig.getMonitorClassPath());
        context.put("title", (Object)"\u76d1\u63a7");
        context.put("errorSize", (Object)this.apiConfig.getMonitorErrorQueueSize());
        this.processMonitorVelocityContext(context);
        this.toHtml(context, res, response);
    }

    public Object monitorData(ApiSearch apiSearch, HttpServletRequest request) {
        if (request.getSession().getAttribute(SESSION_KEY_MONITOR_PASSWORD) == null) {
            return -1;
        }
        MonitorStore store = this.apiConfig.getMonitorStore();
        long total = store.getTotal(apiSearch);
        List<MonitorApiInfo> list = store.getList(apiSearch);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", total);
        map.put("rows", list);
        return map;
    }

    public Object monitorDel(String name, String version) {
        MonitorStore store = this.apiConfig.getMonitorStore();
        store.clean(name, version);
        return Collections.emptyMap();
    }

    protected boolean checkMonitorPassword(HttpServletRequest request) {
        return this.checkPassword(request, this.apiConfig.getMonitorPassword());
    }

    protected void processMonitorVelocityContext(VelocityContext context) {
        this.velocityContextHandler.processMonitorVelocityContext(context);
    }
}

