/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.gitee.easyopen.util.ReflectionUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CopyUtil
extends BeanUtils {
    public static void copyProperties(Map<String, Object> map, Object target) {
        Assert.notNull(map, (String)"map must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        if (target instanceof Map) {
            Map targetMap = (Map)target;
            try {
                targetMap.putAll(map);
            }
            catch (Exception e) {
                throw new FatalBeanException("target\u7684key\u7c7b\u578b\u5fc5\u987b\u4e3aString\uff0cvalue\u7c7b\u578b\u4e3aObject");
            }
        } else {
            Set<Map.Entry<String, Object>> entrySet = map.entrySet();
            Class<?> targetClass = target.getClass();
            for (Map.Entry<String, Object> entry : entrySet) {
                Method[] methods;
                String propertyName = entry.getKey();
                Object val = entry.getValue();
                for (Method method : methods = targetClass.getDeclaredMethods()) {
                    boolean canCopy;
                    String methodName = method.getName();
                    Class<?>[] methodParams = method.getParameterTypes();
                    if (!methodName.startsWith("set")) continue;
                    boolean bl = canCopy = propertyName.equals(ReflectionUtil.buildFieldName(methodName)) && methodParams.length == 1 && methodParams[0].isInstance(val) || Number.class.isInstance(val);
                    if (!canCopy) continue;
                    try {
                        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                            method.setAccessible(true);
                        }
                        method.invoke(target, val);
                    }
                    catch (Throwable ex) {
                        throw new FatalBeanException("Could not copy property '" + propertyName + "' from map to target", ex);
                    }
                }
            }
        }
    }

    public static void copyPropertiesIgnoreNull(Object source, Object target, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = CopyUtil.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = CopyUtil.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                if (value == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

