/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class FieldUtil {
    private static final Logger log = LoggerFactory.getLogger(FieldUtil.class);
    private static final String CLASS_SUFFIX = ".class";

    private FieldUtil() {
    }

    public static boolean isNumberOrStringType(Class<?> type) {
        if (type == String.class) {
            return true;
        }
        if (type.getGenericSuperclass() == Number.class) {
            return true;
        }
        return type.isPrimitive();
    }

    public static String getMethodParameterName(Class<?> clazz, Method method, int index) {
        String[] names = FieldUtil.getMethodParameterNamesByAsm(clazz, method);
        if (names.length == 0) {
            return "";
        }
        return names[index];
    }

    public static String[] getMethodParameterNamesByAsm(Class<?> clazz, final Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return new String[0];
        }
        final Type[] types = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            types[i] = Type.getType(parameterTypes[i]);
        }
        final String[] parameterNames = new String[parameterTypes.length];
        Class realClass = ClassUtils.getUserClass(clazz);
        String className = realClass.getName();
        int lastDotIndex = className.lastIndexOf(46);
        className = className.substring(lastDotIndex + 1) + CLASS_SUFFIX;
        InputStream is = realClass.getResourceAsStream(className);
        try {
            ClassReader classReader = new ClassReader(is);
            classReader.accept(new ClassVisitor(393216){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    Object[] argumentTypes = Type.getArgumentTypes((String)desc);
                    if (!method.getName().equals(name) || !Arrays.equals(argumentTypes, types)) {
                        return null;
                    }
                    return new MethodVisitor(393216){

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                            int i = index - 1;
                            if (Modifier.isStatic(method.getModifiers())) {
                                i = index;
                            }
                            if (i >= 0 && i < parameterNames.length) {
                                parameterNames[i] = name;
                            }
                            super.visitLocalVariable(name, desc, signature, start, end, index);
                        }
                    };
                }
            }, 0);
        }
        catch (IOException e) {
            log.error("\u751f\u6210asm\u5931\u8d25\uff0coriClass:{}, realClass:{} method:{}", new Object[]{clazz.getName(), realClass.getName(), method.toGenericString(), e});
        }
        return parameterNames;
    }
}

