/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.alibaba.fastjson.JSON;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtil {
    private static final Logger log = LoggerFactory.getLogger(PDFUtil.class);
    private static final String UTF8 = "UTF-8";
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static void htmlToPDF(String htmlString, String css, OutputStream out, PDFInfo pdfInfo) {
        try {
            Document document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            if (pdfInfo != null) {
                document.addAuthor(pdfInfo.getAuthor());
                document.addCreator(pdfInfo.getCreator());
                document.addSubject(pdfInfo.getSubject());
                document.addTitle(pdfInfo.getTitle());
            }
            document.addCreationDate();
            XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
            ByteArrayInputStream cssInput = new ByteArrayInputStream(css.getBytes(UTF8));
            ByteArrayInputStream htmlInput = new ByteArrayInputStream(htmlString.getBytes(UTF8));
            worker.parseXHtml(pdfWriter, document, (InputStream)htmlInput, (InputStream)cssInput, CHARSET_UTF8, (FontProvider)new AsianFontProvider());
            document.close();
        }
        catch (Exception e) {
            log.error("html\u8f6cpdf\u51fa\u9519, pdfInfo:{}", pdfInfo == null ? "" : JSON.toJSON((Object)pdfInfo), (Object)e);
        }
    }

    public static class AsianFontProvider
    extends XMLWorkerFontProvider {
        public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
            try {
                BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                Font font = new Font(bf, size, style, color);
                font.setColor(color);
                return font;
            }
            catch (Exception e) {
                log.error("getFont\u51fa\u9519", (Throwable)e);
                return super.getFont(fontname, encoding, embedded, size, style, color);
            }
        }
    }

    public static class PDFInfo {
        private String author;
        private String creator;
        private String subject;
        private String title;

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

