/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.gitee.easyopen.util.KeyStore;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSANewUtil {
    public static final String RSA_ALGORITHM = "RSA";
    public static final String UTF8 = "UTF-8";

    public static KeyStore createKeys() throws Exception {
        KeyPairGenerator keyPairGeno = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyPairGeno.initialize(1024);
        KeyPair keyPair = keyPairGeno.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        KeyStore keyStore = new KeyStore();
        keyStore.setPublicKey(Base64.encodeBase64String((byte[])publicKey.getEncoded()));
        keyStore.setPrivateKey(Base64.encodeBase64String((byte[])privateKey.getEncoded()));
        return keyStore;
    }

    public static RSAPublicKey getPublicKey(byte[] pubKeyData) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyData);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    public static RSAPublicKey getPublicKey(String pubKey) throws Exception {
        return RSANewUtil.getPublicKey(Base64.decodeBase64((String)pubKey));
    }

    public static RSAPrivateKey getPrivateKey(String priKey) throws Exception {
        return RSANewUtil.getPrivateKey(Base64.decodeBase64((String)priKey));
    }

    public static RSAPrivateKey getPrivateKey(byte[] keyBytes) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
    }

    public static String encryptByPublicKey(String data, String publicKey) throws Exception {
        return RSANewUtil.encryptByPublicKey(data, RSANewUtil.getPublicKey(publicKey));
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, publicKey);
        byte[] bytes = cipher.doFinal(data.getBytes(UTF8));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decryptByPublicKey(String data, String rsaPublicKey) throws Exception {
        return RSANewUtil.decryptByPublicKey(data, RSANewUtil.getPublicKey(rsaPublicKey));
    }

    public static String decryptByPublicKey(String data, RSAPublicKey rsaPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, rsaPublicKey);
        byte[] inputData = Base64.decodeBase64((String)data);
        byte[] bytes = cipher.doFinal(inputData);
        return new String(bytes, UTF8);
    }

    public static String encryptByPrivateKey(String data, String privateKey) throws Exception {
        return RSANewUtil.encryptByPrivateKey(data, RSANewUtil.getPrivateKey(privateKey));
    }

    public static String encryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, privateKey);
        byte[] bytes = cipher.doFinal(data.getBytes(UTF8));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decryptByPrivateKey(String data, String privateKey) throws Exception {
        return RSANewUtil.decryptByPrivateKey(data, RSANewUtil.getPrivateKey(privateKey));
    }

    public static String decryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, privateKey);
        byte[] inputData = Base64.decodeBase64((String)data);
        byte[] bytes = cipher.doFinal(inputData);
        return new String(bytes, UTF8);
    }
}

