/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.gitee.easyopen.util.KeyStore;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    public static String RSA_ALGORITHM = "RSA";

    public static KeyStore createKeys() throws Exception {
        KeyPairGenerator keyPairGeno = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        keyPairGeno.initialize(1024);
        KeyPair keyPair = keyPairGeno.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        KeyStore keyStore = new KeyStore();
        keyStore.setPublicKey(Base64.encodeBase64String((byte[])publicKey.getEncoded()));
        keyStore.setPrivateKey(Base64.encodeBase64String((byte[])privateKey.getEncoded()));
        return keyStore;
    }

    public static RSAPublicKey getPublicKey(byte[] pubKeyData) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyData);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    public static RSAPublicKey getPublicKey(String pubKey) throws Exception {
        return RSAUtil.getPublicKey(Base64.decodeBase64((String)pubKey));
    }

    public static RSAPrivateKey getPrivateKey(String priKey) throws Exception {
        return RSAUtil.getPrivateKey(Base64.decodeBase64((String)priKey));
    }

    public static RSAPrivateKey getPrivateKey(byte[] keyBytes) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, publicKey);
        int key_len = publicKey.getModulus().bitLength() / 8;
        String[] datas = RSAUtil.splitString(data, key_len - 11);
        String mi = "";
        for (String s : datas) {
            mi = mi + RSAUtil.bcd2Str(cipher.doFinal(s.getBytes()));
        }
        return mi;
    }

    public static String encryptByPrivateKey(String data, String privateKey) throws Exception {
        return RSAUtil.encryptByPrivateKey(data, RSAUtil.getPrivateKey(privateKey));
    }

    public static String encryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, privateKey);
        int key_len = privateKey.getModulus().bitLength() / 8;
        String[] datas = RSAUtil.splitString(data, key_len - 11);
        String mi = "";
        for (String s : datas) {
            mi = mi + RSAUtil.bcd2Str(cipher.doFinal(s.getBytes()));
        }
        return mi;
    }

    public static String decryptByPrivateKey(String data, String privateKey) throws Exception {
        return RSAUtil.decryptByPrivateKey(data, RSAUtil.getPrivateKey(privateKey));
    }

    public static String decryptByPrivateKey(String data, RSAPrivateKey privateKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, privateKey);
        int key_len = privateKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RSAUtil.ASCII_To_BCD(bytes, bytes.length);
        String ming = "";
        for (byte[] arr : arrays = RSAUtil.splitArray(bcd, key_len)) {
            ming = ming + new String(cipher.doFinal(arr));
        }
        return ming;
    }

    public static String decryptByPublicKey(String data, RSAPublicKey rsaPublicKey) throws Exception {
        byte[][] arrays;
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, rsaPublicKey);
        int key_len = rsaPublicKey.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RSAUtil.ASCII_To_BCD(bytes, bytes.length);
        String ming = "";
        for (byte[] arr : arrays = RSAUtil.splitArray(bcd, key_len)) {
            ming = ming + new String(cipher.doFinal(arr));
        }
        return ming;
    }

    public static byte[] ASCII_To_BCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        for (int i = 0; i < (asc_len + 1) / 2; ++i) {
            bcd[i] = RSAUtil.asc_to_bcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? 0 : RSAUtil.asc_to_bcd(ascii[j++]) & 0xFF) + (bcd[i] << 4));
        }
        return bcd;
    }

    public static byte asc_to_bcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public static String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    public static String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        for (int i = 0; i < x + z; ++i) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
        }
        return strings;
    }

    public static byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }
}

