/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import java.util.Collections;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisLockUtil {
    private static final Long SUCCESS = 1L;
    private static final String SCRIPT_LOCK = "if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]) return 1 else return 0 end";
    private static final String SCRIPT_UNLOCK = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static final String SCRIPT_LOCK_SHA1 = DigestUtils.sha1Hex((String)"if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]) return 1 else return 0 end");
    private static final String SCRIPT_UNLOCK_SHA1 = DigestUtils.sha1Hex((String)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end");

    public static boolean tryGetDistributedLock(RedisTemplate redisTemplate, String lockKey, String requestId, int expireTimeMilliseconds) {
        Object result = redisTemplate.execute((RedisScript)new RedisScript<Long>(){

            public String getSha1() {
                return SCRIPT_LOCK_SHA1;
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public String getScriptAsString() {
                return RedisLockUtil.SCRIPT_LOCK;
            }
        }, Collections.singletonList(lockKey), new Object[]{requestId, String.valueOf(expireTimeMilliseconds)});
        return SUCCESS.equals(result);
    }

    public static boolean releaseDistributedLock(RedisTemplate redisTemplate, String lockKey, String requestId) {
        Object result = redisTemplate.execute((RedisScript)new RedisScript<Long>(){

            public String getSha1() {
                return SCRIPT_UNLOCK_SHA1;
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public String getScriptAsString() {
                return RedisLockUtil.SCRIPT_UNLOCK;
            }
        }, Collections.singletonList(lockKey), new Object[]{requestId});
        return SUCCESS.equals(result);
    }
}

