/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.easyopen.util;

import com.gitee.easyopen.annotation.ApiService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;

public class ReflectionUtil {
    public static final String PREFIX_SET = "set";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static Map<String, Class<?>> classGenricTypeCache = new HashMap(16);
    private static Map<String, Field> genericTypeFieldCache = new HashMap<String, Field>();

    public static void invokeFieldValue(Object target, String fieldName, Object val) {
        Method[] methods;
        String setMethodName = ReflectionUtil.getSetMethodName(fieldName);
        for (Method method : methods = target.getClass().getDeclaredMethods()) {
            boolean canCopy;
            String methodName = method.getName();
            Class<?>[] methodParams = method.getParameterTypes();
            if (!setMethodName.equals(methodName)) continue;
            boolean bl = canCopy = methodParams.length == 1 && methodParams[0].isInstance(val) || Number.class.isInstance(val);
            if (!canCopy) continue;
            try {
                if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method.setAccessible(true);
                }
                method.invoke(target, val);
                break;
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not set property '" + fieldName + "' value to target", ex);
            }
        }
    }

    public static Field getListFieldWithGeneric(Object obj, Class<?> genericClass) {
        Field[] fields;
        Class<?> objClass = obj.getClass();
        String key = objClass.getName() + genericClass.getName();
        Field value = genericTypeFieldCache.get(key);
        if (value != null) {
            return value;
        }
        for (Field field : fields = objClass.getDeclaredFields()) {
            Type genericType = ReflectionUtil.getListGenericType(field);
            if (genericType != genericClass) continue;
            genericTypeFieldCache.put(key, field);
            return field;
        }
        return null;
    }

    public static Type getListGenericType(Field field) {
        Type[] params;
        Type genericType;
        if (ReflectionUtil.isListType(field.getType()) && (genericType = field.getGenericType()) instanceof ParameterizedType && (params = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            return params[0];
        }
        return Object.class;
    }

    public static boolean isListType(Type type) {
        return type == List.class;
    }

    public static String getSetMethodName(String fieldName) {
        return PREFIX_SET + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static String buildFieldName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        String cacheKey = clazz.getName() + index;
        Class<?> cachedClass = classGenricTypeCache.get(cacheKey);
        if (cachedClass != null) {
            return cachedClass;
        }
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            throw new RuntimeException("class " + clazz.getName() + " \u6ca1\u6709\u6307\u5b9a\u7236\u7c7b\u6cdb\u578b");
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            throw new RuntimeException("\u6cdb\u578b\u7d22\u5f15\u4e0d\u6b63\u786e\uff0cindex:" + index);
        }
        if (!(params[index] instanceof Class)) {
            throw new RuntimeException(params[index] + "\u4e0d\u662fClass\u7c7b\u578b");
        }
        Class retClass = (Class)params[index];
        classGenricTypeCache.put(cacheKey, retClass);
        return retClass;
    }

    public static String[] findApiServiceNames(ApplicationContext ctx) {
        return ReflectionUtil.findBeanNamesByAnnotationClass(ctx, ApiService.class);
    }

    public static String[] findBeanNamesByAnnotationClass(ApplicationContext ctx, Class<? extends Annotation> annotationClass) {
        ApplicationContext parentCtx;
        String[] beans = ctx.getBeanNamesForAnnotation(annotationClass);
        if ((beans == null || beans.length == 0) && (parentCtx = ctx.getParent()) != null) {
            beans = parentCtx.getBeanNamesForAnnotation(annotationClass);
        }
        if (beans == null) {
            beans = EMPTY_STRING_ARRAY;
        }
        return beans;
    }
}

